/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.compiler;

import cc.tweaked.cobalt.internal.unwind.AutoUnwind;
import cc.tweaked.cobalt.internal.unwind.Pause;
import cc.tweaked.cobalt.internal.unwind.UnwindState;
import cc.tweaked.cobalt.internal.unwind.UnwindState$L0O4;
import cc.tweaked.cobalt.internal.unwind.UnwindState$L4O0;
import cc.tweaked.cobalt.internal.unwind.UnwindState$L4O4;
import cc.tweaked.cobalt.internal.unwind.UnwindState$L8O4;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.squiddev.cobalt.Buffer;
import org.squiddev.cobalt.Lua;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaInteger;
import org.squiddev.cobalt.LuaNumber;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.Prototype;
import org.squiddev.cobalt.compiler.BinOpr;
import org.squiddev.cobalt.compiler.CompileException;
import org.squiddev.cobalt.compiler.ExpKind;
import org.squiddev.cobalt.compiler.FuncState;
import org.squiddev.cobalt.compiler.InputReader;
import org.squiddev.cobalt.compiler.IntPtr;
import org.squiddev.cobalt.compiler.Lex;
import org.squiddev.cobalt.compiler.LuaC;
import org.squiddev.cobalt.compiler.UnOpr;
import org.squiddev.cobalt.function.LocalVariable;

@AutoUnwind
final class Parser {
    private static final int LUAI_MAXCCALLS = 200;
    private static final boolean LUA_COMPAT_VARARG = true;
    static final int NO_JUMP = -1;
    final Lex lexer;
    final LuaString envName;
    final LuaString gotoName;
    FuncState fs;
    public int nCcalls;
    private final List<LabelDesc> activeLabels = new ArrayList<LabelDesc>();
    private final List<LabelDesc> pendingGotos = new ArrayList<LabelDesc>();
    private int activeVariableSize;
    private short[] activeVariables = new short[16];

    private static String LUA_QL(String s) {
        return "'" + s + "'";
    }

    public Parser(InputReader stream, int firstByte, LuaString source, LuaString shortSource) {
        this.lexer = new Lex(source, shortSource, stream, firstByte);
        this.envName = this.lexer.newString("_ENV");
        this.gotoName = this.lexer.newString("goto");
        this.fs = null;
    }

    CompileException syntaxError(String msg) {
        return this.lexer.syntaxError(msg);
    }

    CompileException semError(String msg) {
        return this.lexer.lexError(msg, 0);
    }

    private void errorExpected(int token) throws CompileException {
        throw this.syntaxError(Lex.token2str(token) + " expected");
    }

    private void errorLimit(FuncState fs, int limit, String what) throws CompileException {
        String msg = fs.lineDefined == 0 ? "main function has more than " + limit + " " + what : "function at line " + fs.lineDefined + " has more than " + limit + " " + what;
        throw this.lexer.lexError(msg, 0);
    }

    private void checkLimit(FuncState fs, int value, int limit, String msg) throws CompileException {
        if (value > limit) {
            this.errorLimit(fs, limit, msg);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean testNext(int n, Object object) throws CompileException, LuaError, Pause {
        Object object2;
        Lex lex;
        if (object == null) {
            void c;
            if (this.lexer.token.token() != c) {
                return false;
            }
            lex = this.lexer;
            object2 = null;
        } else {
            object = (UnwindState)object;
            if (((UnwindState)object).state != 0) {
                throw new IllegalStateException("Resuming into unknown state");
            }
            lex = this.lexer;
            object2 = ((UnwindState)object).child;
        }
        try {
            lex.nextToken(object2);
            return true;
        }
        catch (Pause pause) {
            object = UnwindState.getOrCreate(object);
            pause.pushState((UnwindState)object);
            ((UnwindState)object).state = 0;
            throw pause;
        }
    }

    void check(int c) throws CompileException {
        if (this.lexer.token.token() != c) {
            this.errorExpected(c);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkNext(int n, Object object) throws CompileException, LuaError, Pause {
        Object object2;
        Lex lex;
        if (object == null) {
            void c;
            this.check((int)c);
            lex = this.lexer;
            object2 = null;
        } else {
            object = (UnwindState)object;
            if (((UnwindState)object).state != 0) {
                throw new IllegalStateException("Resuming into unknown state");
            }
            lex = this.lexer;
            object2 = ((UnwindState)object).child;
        }
        try {
            lex.nextToken(object2);
            return;
        }
        catch (Pause pause) {
            object = UnwindState.getOrCreate(object);
            pause.pushState((UnwindState)object);
            ((UnwindState)object).state = 0;
            throw pause;
        }
    }

    private void checkCondition(boolean c, String msg) throws CompileException {
        if (!c) {
            throw this.syntaxError(msg);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkMatch(int n, int n2, int n3, Object object) throws CompileException, LuaError, Pause {
        Object object2;
        boolean bl;
        void what;
        Parser parser;
        if (object == null) {
            parser = this;
            bl = what;
            object2 = null;
        } else {
            object = (UnwindState$L4O0)object;
            if (((UnwindState$L4O0)object).state != 0) {
                throw new IllegalStateException("Resuming into unknown state");
            }
            n = (int)((UnwindState$L4O0)object).l0;
            n2 = (int)((UnwindState$L4O0)object).l1;
            n3 = (int)((UnwindState$L4O0)object).l2;
            parser = this;
            bl = false;
            object2 = ((UnwindState)object).child;
        }
        try {
            void where;
            if (parser.testNext(bl ? 1 : 0, object2)) {
                return;
            }
            if (where != this.lexer.token.line()) void who;
            throw this.syntaxError(Lex.token2str((int)what) + " expected (to close " + Lex.token2str((int)who) + " at line " + (int)where + ")");
            this.errorExpected((int)what);
            return;
        }
        catch (Pause pause) {
            object = UnwindState$L4O0.getOrCreate(object);
            pause.pushState((UnwindState)object);
            ((UnwindState)object).state = 0;
            ((UnwindState$L4O0)object).l0 = n;
            ((UnwindState$L4O0)object).l1 = n2;
            ((UnwindState$L4O0)object).l2 = n3;
            throw pause;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LuaString strCheckName(Object object) throws CompileException, LuaError, Pause {
        LuaString luaString;
        Object object2;
        Lex lex;
        LuaString ts;
        if (object == null) {
            this.check(288);
            ts = this.lexer.token.stringContents();
            lex = this.lexer;
            object2 = null;
        } else {
            object = (UnwindState$L0O4)object;
            if (((UnwindState$L0O4)object).state != 0) {
                throw new IllegalStateException("Resuming into unknown state");
            }
            luaString = (LuaString)((UnwindState$L0O4)object).o0;
            lex = this.lexer;
            object2 = ((UnwindState)object).child;
        }
        try {
            lex.nextToken(object2);
            return ts;
        }
        catch (Pause pause) {
            object = UnwindState$L0O4.getOrCreate(object);
            pause.pushState((UnwindState)object);
            ((UnwindState)object).state = 0;
            ((UnwindState$L0O4)object).o0 = luaString;
            throw pause;
        }
    }

    private void codeString(ExpDesc e, LuaString s) {
        e.init(ExpKind.VK, this.fs.stringK(s));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkName(ExpDesc expDesc, Object object) throws CompileException, LuaError, Pause {
        Object object2;
        Parser parser;
        ExpDesc expDesc2;
        Parser parser2;
        if (object == null) {
            void e;
            parser2 = this;
            expDesc2 = e;
            parser = this;
            object2 = null;
        } else {
            object = (UnwindState$L0O4)object;
            if (((UnwindState$L0O4)object).state != 0) {
                throw new IllegalStateException("Resuming into unknown state");
            }
            expDesc = (ExpDesc)((UnwindState$L0O4)object).o0;
            parser2 = this;
            expDesc2 = expDesc;
            parser = this;
            object2 = ((UnwindState)object).child;
        }
        try {
            parser2.codeString(expDesc2, parser.strCheckName(object2));
            return;
        }
        catch (Pause pause) {
            object = UnwindState$L0O4.getOrCreate(object);
            pause.pushState((UnwindState)object);
            ((UnwindState)object).state = 0;
            ((UnwindState$L0O4)object).o0 = expDesc;
            throw pause;
        }
    }

    private int registerLocal(LuaString name) {
        FuncState fs = this.fs;
        int index = fs.locals.size();
        fs.locals.add(new LocalVariable(name, 0, 0));
        return index;
    }

    private void newLocal(String name) throws CompileException {
        this.newLocal(this.lexer.newString(name));
    }

    private void newLocal(LuaString name) throws CompileException {
        FuncState fs = this.fs;
        this.checkLimit(fs, this.activeVariableSize + 1, 200, "local variables");
        if (this.activeVariableSize >= this.activeVariables.length) {
            this.activeVariables = LuaC.realloc(this.activeVariables, this.activeVariables.length * 2 + 1);
        }
        this.activeVariables[this.activeVariableSize++] = (short)this.registerLocal(name);
    }

    LocalVariable getLocal(FuncState fs, int i) {
        return fs.locals.get(this.activeVariables[fs.firstLocal + i]);
    }

    private void adjustLocalVars(int nVars) {
        FuncState fs = this.fs;
        fs.activeVariableCount = (short)(fs.activeVariableCount + nVars);
        while (nVars > 0) {
            this.getLocal((FuncState)fs, (int)(fs.activeVariableCount - nVars)).startpc = fs.pc;
            --nVars;
        }
    }

    void removeVars(int toLevel) {
        FuncState fs = this.fs;
        this.activeVariableSize -= fs.activeVariableCount - toLevel;
        while (fs.activeVariableCount > toLevel) {
            fs.activeVariableCount = (short)(fs.activeVariableCount - 1);
            this.getLocal((FuncState)fs, (int)((short)(fs.activeVariableCount - 1))).endpc = fs.pc;
        }
    }

    private int searchUpvalue(FuncState fs, LuaString name) {
        for (int i = 0; i < fs.upvalues.size(); ++i) {
            if (fs.upvalues.get(i).name() != name) continue;
            return i;
        }
        return -1;
    }

    private int newUpvalue(FuncState fs, LuaString name, ExpDesc v) throws CompileException {
        this.checkLimit(fs, fs.upvalues.size(), 60, "upvalues");
        assert (v.kind == ExpKind.VLOCAL || v.kind == ExpKind.VUPVAL);
        int index = fs.upvalues.size();
        fs.upvalues.add(new Prototype.UpvalueInfo(name, v.kind == ExpKind.VLOCAL, (byte)v.info));
        return index;
    }

    private int searchVar(FuncState fs, LuaString n) {
        for (int i = fs.activeVariableCount - 1; i >= 0; --i) {
            if (n != this.getLocal((FuncState)fs, (int)i).name) continue;
            return i;
        }
        return -1;
    }

    private void markUpvalue(FuncState fs, int level) {
        FuncState.BlockCnt block = fs.block;
        while (block != null && block.activeVariableCount > level) {
            block = block.previous;
        }
        if (block != null) {
            block.upval = true;
        }
    }

    private ExpKind singleVarAux(FuncState fs, LuaString n, ExpDesc var, boolean base) throws CompileException {
        if (fs == null) {
            return ExpKind.VVOID;
        }
        int v = this.searchVar(fs, n);
        if (v >= 0) {
            var.init(ExpKind.VLOCAL, v);
            if (!base) {
                this.markUpvalue(fs, v);
            }
            return ExpKind.VLOCAL;
        }
        int index = this.searchUpvalue(fs, n);
        if (index < 0) {
            if (this.singleVarAux(fs.prev, n, var, false) == ExpKind.VVOID) {
                return ExpKind.VVOID;
            }
            index = this.newUpvalue(fs, n, var);
        }
        var.init(ExpKind.VUPVAL, index);
        return ExpKind.VUPVAL;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void singleVar(ExpDesc expDesc, Object object) throws CompileException, LuaError, Pause {
        Object object2;
        Parser parser;
        if (object == null) {
            var.position = this.lexer.token.position();
            parser = this;
            object2 = null;
        } else {
            object = (UnwindState$L0O4)object;
            if (((UnwindState$L0O4)object).state != 0) {
                throw new IllegalStateException("Resuming into unknown state");
            }
            expDesc = (ExpDesc)((UnwindState$L0O4)object).o0;
            parser = this;
            object2 = ((UnwindState)object).child;
        }
        try {
            void var;
            LuaString varName = parser.strCheckName(object2);
            FuncState fs = this.fs;
            if (this.singleVarAux(fs, varName, (ExpDesc)var, true) == ExpKind.VVOID) {
                ExpDesc key = new ExpDesc();
                ExpKind global = this.singleVarAux(fs, this.envName, (ExpDesc)var, true);
                assert (global == ExpKind.VLOCAL || global == ExpKind.VUPVAL);
                this.codeString(key, varName);
                fs.indexed((ExpDesc)var, key, var.position);
            }
            return;
        }
        catch (Pause pause) {
            object = UnwindState$L0O4.getOrCreate(object);
            pause.pushState((UnwindState)object);
            ((UnwindState)object).state = 0;
            ((UnwindState$L0O4)object).o0 = expDesc;
            throw pause;
        }
    }

    private void adjustAssign(int nvars, int nexps, ExpDesc e) throws CompileException {
        FuncState fs = this.fs;
        int extra = nvars - nexps;
        if (e.kind.hasMultiRet()) {
            if (++extra < 0) {
                extra = 0;
            }
            fs.setReturns(e, extra);
            if (extra > 1) {
                fs.reserveRegs(extra - 1);
            }
        } else {
            if (e.kind != ExpKind.VVOID) {
                fs.exp2NextReg(e);
            }
            if (extra > 0) {
                int reg = fs.freeReg;
                fs.reserveRegs(extra);
                fs.nil(reg, extra);
            }
        }
        if (nexps > nvars) {
            fs.freeReg -= nexps - nvars;
        }
    }

    private void enterLevel() throws CompileException {
        ++this.nCcalls;
        this.checkLimit(this.fs, this.nCcalls, 200, "syntax levels");
    }

    private void leaveLevel() {
        --this.nCcalls;
    }

    private void closeGoto(int g, LabelDesc label) throws CompileException {
        LabelDesc gt = this.pendingGotos.get(g);
        assert (gt.name == label.name);
        if (gt.activeVariables < label.activeVariables) {
            LuaString local = this.getLocal((FuncState)this.fs, (int)gt.activeVariables).name;
            throw this.semError("<goto " + String.valueOf(gt.name) + "> at line " + gt.line + " jumps into the scope of local '" + String.valueOf(local) + "'");
        }
        this.fs.patchList(gt.pc, label.pc);
        this.pendingGotos.remove(g);
    }

    private boolean findLabel(int g) throws CompileException {
        FuncState.BlockCnt block = this.fs.block;
        LabelDesc gt = this.pendingGotos.get(g);
        for (int i = block.firstLabel; i < this.activeLabels.size(); ++i) {
            LabelDesc label = this.activeLabels.get(i);
            if (label.name != gt.name) continue;
            assert (block.upval || this.activeLabels.size() > block.firstLabel);
            if (gt.activeVariables > label.activeVariables) {
                this.fs.patchClose(gt.pc, label.activeVariables);
            }
            this.closeGoto(g, label);
            return true;
        }
        return false;
    }

    private int newLabelEntry(List<LabelDesc> labels, LuaString label, int line, int pc) throws CompileException {
        this.checkLimit(this.fs, labels.size() + 1, Short.MAX_VALUE, "labels/gotos");
        int index = labels.size();
        labels.add(new LabelDesc(label, pc, line, this.fs.activeVariableCount));
        return index;
    }

    private void findGotos(LabelDesc label) throws CompileException {
        int i = this.fs.block.firstGoto;
        while (i < this.pendingGotos.size()) {
            if (this.pendingGotos.get((int)i).name == label.name) {
                this.closeGoto(i, label);
                continue;
            }
            ++i;
        }
    }

    private void moveGotosOut(FuncState.BlockCnt bl) throws CompileException {
        int i = bl.firstGoto;
        while (i < this.pendingGotos.size()) {
            LabelDesc gt = this.pendingGotos.get(i);
            if (gt.activeVariables > bl.activeVariableCount) {
                if (bl.upval) {
                    this.fs.patchClose(gt.pc, bl.activeVariableCount);
                }
                gt.activeVariables = bl.activeVariableCount;
            }
            if (this.findLabel(i)) continue;
            ++i;
        }
    }

    private void enterBlock(FuncState fs, boolean isLoop) {
        this.enterBlock(fs, new FuncState.BlockCnt(), isLoop);
    }

    private void enterBlock(FuncState fs, FuncState.BlockCnt bl, boolean isLoop) {
        bl.isLoop = isLoop;
        bl.activeVariableCount = fs.activeVariableCount;
        bl.firstLabel = (short)this.activeLabels.size();
        bl.firstGoto = (short)this.pendingGotos.size();
        bl.upval = false;
        bl.previous = fs.block;
        fs.block = bl;
        assert (fs.freeReg == fs.activeVariableCount);
    }

    private void breakLabel() throws CompileException {
        int label = this.newLabelEntry(this.activeLabels, this.lexer.newString("break"), 0, this.fs.pc);
        this.findGotos(this.activeLabels.get(label));
    }

    private CompileException undefGoto(LabelDesc gt) {
        Buffer buffer = this.lexer.createErrorMessage(gt.line);
        if (Lex.isReserved(gt.name)) {
            buffer.append(gt.name).append(" outside loop at line ").append(Integer.toString(gt.line));
        } else {
            buffer.append("no visible label '").append(gt.name).append("' for <goto> at line ").append(Integer.toString(gt.line));
        }
        return new CompileException(buffer.toString());
    }

    private void leaveBlock(FuncState fs) throws CompileException {
        FuncState.BlockCnt bl = fs.block;
        if (bl.previous != null && bl.upval) {
            int j = fs.jump();
            fs.patchClose(j, bl.activeVariableCount);
            fs.patchToHere(j);
        }
        if (bl.isLoop) {
            this.breakLabel();
        }
        fs.block = bl.previous;
        this.removeVars(bl.activeVariableCount);
        assert (bl.activeVariableCount == fs.activeVariableCount);
        fs.freeReg = fs.activeVariableCount;
        while (this.activeLabels.size() > bl.firstLabel) {
            this.activeLabels.remove(this.activeLabels.size() - 1);
        }
        if (bl.previous != null) {
            this.moveGotosOut(bl);
        } else if (bl.firstGoto < this.pendingGotos.size()) {
            throw this.undefGoto(this.pendingGotos.get(bl.firstGoto));
        }
    }

    private void codeClosure(Prototype childPrototype, ExpDesc v) throws CompileException {
        FuncState current = this.fs;
        int index = current.children.size();
        current.children.add(childPrototype);
        v.init(ExpKind.VRELOCABLE, current.codeABx(37, 0, index));
        this.fs.exp2NextReg(v);
    }

    FuncState openFunc() throws CompileException {
        FuncState fs;
        if (this.fs != null) {
            this.checkLimit(this.fs, this.fs.children.size(), 262143, "functions");
        }
        this.fs = fs = new FuncState(this.lexer, this.fs, this.activeVariableSize, this.activeLabels.size());
        this.enterBlock(fs, false);
        return fs;
    }

    Prototype closeFunc() throws CompileException {
        FuncState fs = this.fs;
        fs.ret(0, 0);
        this.leaveBlock(fs);
        assert (fs.block == null);
        this.fs = fs.prev;
        return fs.toPrototype();
    }

    private boolean blockFollow(boolean withUntil) {
        return switch (this.lexer.token.token()) {
            case 260, 261, 262, 286 -> true;
            case 277 -> withUntil;
            default -> false;
        };
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void statementList(Object var1_1) throws CompileException, LuaError, Pause {
        block13: {
            block12: {
                block11: {
                    if (var1_1 == null) lbl-1000:
                    // 2 sources

                    {
                        while (!this.blockFollow(true)) {
                            if (this.lexer.token.token() != 274) break block11;
                            v0 = this;
                            v1 = null;
lbl6:
                            // 2 sources

                            while (true) {
                                v0.statement(v1);
                                return;
                                break;
                            }
                        }
                        return;
                    }
                    var1_1 = (UnwindState)var1_1;
                    switch (var1_1.state) {
                        default: {
                            throw new IllegalStateException("Resuming into unknown state");
                        }
                        case 0: {
                            v0 = this;
                            v1 = var1_1.child;
                            ** continue;
                        }
                        case 1: 
                    }
                    v2 = this;
                    v3 = var1_1.child;
                    break block12;
                }
                v2 = this;
                v3 = null;
            }
            try {}
            catch (Pause v4) {
                var1_1 = UnwindState.getOrCreate(var1_1);
                v4.pushState((UnwindState)var1_1);
                var1_1.state = 1;
                throw v4;
            }
            break block13;
            catch (Pause v5) {
                var1_1 = UnwindState.getOrCreate(var1_1);
                v5.pushState((UnwindState)var1_1);
                var1_1.state = 0;
                throw v5;
            }
        }
        v2.statement(v3);
        ** GOTO lbl-1000
    }

    /*
     * Unable to fully structure code
     */
    private void fieldSelect(ExpDesc var1_1, Object var2_2) throws CompileException, LuaError, Pause {
        if (var2_2 == null) {
            key = new ExpDesc();
            this.fs.exp2AnyRegUp((ExpDesc)v);
            indexPos = this.lexer.token.position();
            v0 = this.lexer;
            v1 = null;
lbl7:
            // 2 sources

            while (true) {
                v0.nextToken(v1);
                v2 = this;
                v3 = key;
                v4 = null;
lbl13:
                // 2 sources

                while (true) {
                    v2.checkName(v3, v4);
                    this.fs.indexed((ExpDesc)v, key, indexPos);
                    return;
                    break;
                }
                break;
            }
        }
        var2_2 = (UnwindState$L4O4)var2_2;
        switch (var2_2.state) {
            default: {
                throw new IllegalStateException("Resuming into unknown state");
            }
            case 0: {
                var1_1 = (ExpDesc)var2_2.o0;
                var3_3 = (ExpDesc)var2_2.o1;
                var4_4 = var2_2.l0;
                v0 = this.lexer;
                v1 = var2_2.child;
                ** continue;
            }
            case 1: 
        }
        var1_1 = (ExpDesc)var2_2.o0;
        var3_3 = (ExpDesc)var2_2.o1;
        var4_4 = var2_2.l0;
        v2 = this;
        v3 = null;
        v4 = var2_2.child;
        ** while (true)
        catch (Pause v5) {
            var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
            v5.pushState((UnwindState)var2_2);
            var2_2.state = 0;
            var2_2.o0 = var1_1;
            var2_2.o1 = var3_3;
            var2_2.l0 = var4_4;
            throw v5;
        }
        catch (Pause v6) {
            var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
            v6.pushState((UnwindState)var2_2);
            var2_2.state = 1;
            var2_2.o0 = var1_1;
            var2_2.o1 = var3_3;
            var2_2.l0 = var4_4;
            throw v6;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void yindex(ExpDesc var1_1, Object var2_2) throws CompileException, LuaError, Pause {
        if (var2_2 == null) {
            v0 = this.lexer;
            v1 = null;
lbl4:
            // 2 sources

            while (true) {
                v0.nextToken(v1);
                v2 = this;
                v3 = v;
                v4 = null;
lbl10:
                // 2 sources

                while (true) {
                    v2.expression(v3, v4);
                    this.fs.exp2Val((ExpDesc)v);
                    v5 = this;
                    v6 = 93;
                    v7 = null;
lbl17:
                    // 2 sources

                    while (true) {
                        v5.checkNext(v6, v7);
                        return;
                        break;
                    }
                    break;
                }
                break;
            }
        }
        var2_2 = (UnwindState$L0O4)var2_2;
        switch (var2_2.state) {
            default: {
                throw new IllegalStateException("Resuming into unknown state");
            }
            case 0: {
                var1_1 = (ExpDesc)var2_2.o0;
                v0 = this.lexer;
                v1 = var2_2.child;
                ** continue;
            }
            case 1: {
                var1_1 = (ExpDesc)var2_2.o0;
                v2 = this;
                v3 = null;
                v4 = var2_2.child;
                ** continue;
            }
            case 2: 
        }
        v5 = this;
        v6 = 0;
        v7 = var2_2.child;
        ** while (true)
        catch (Pause v8) {
            var2_2 = UnwindState$L0O4.getOrCreate(var2_2);
            v8.pushState((UnwindState)var2_2);
            var2_2.state = 0;
            var2_2.o0 = var1_1;
            throw v8;
        }
        catch (Pause v9) {
            var2_2 = UnwindState$L0O4.getOrCreate(var2_2);
            v9.pushState((UnwindState)var2_2);
            var2_2.state = 1;
            var2_2.o0 = var1_1;
            throw v9;
        }
        catch (Pause v10) {
            var2_2 = UnwindState$L0O4.getOrCreate(var2_2);
            v10.pushState((UnwindState)var2_2);
            var2_2.state = 2;
            throw v10;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void recordField(ConsControl var1_1, Object var2_2) throws CompileException, LuaError, Pause {
        block18: {
            block19: {
                if (var2_2 != null) break block18;
                fs = this.fs;
                reg = this.fs.freeReg;
                key = new ExpDesc();
                val = new ExpDesc();
                if (this.lexer.token.token() != 288) break block19;
                this.checkLimit(fs, cc.hashSize, 0x7FFFFFFD, "items in a constructor");
                v0 = this;
                v1 = key;
                v2 = null;
lbl11:
                // 2 sources

                while (true) {
                    v0.checkName(v1, v2);
                    ** GOTO lbl22
                    break;
                }
            }
            v3 = this;
            v4 = key;
            v5 = null;
lbl19:
            // 2 sources

            while (true) {
                v3.yindex(v4, v5);
lbl22:
                // 2 sources

                ++cc.hashSize;
                v6 = this;
                v7 = 61;
                v8 = null;
lbl26:
                // 2 sources

                while (true) {
                    v6.checkNext(v7, v8);
                    rkkey = fs.exp2RK(key);
                    v9 = this;
                    v10 = val;
                    v11 = null;
lbl33:
                    // 2 sources

                    while (true) {
                        v9.expression(v10, v11);
                        fs.codeABC(10, cc.table.info, rkkey, fs.exp2RK(val));
                        fs.freeReg = reg;
                        return;
                    }
                    break;
                }
                break;
            }
        }
        var2_2 = (UnwindState$L4O4)var2_2;
        switch (var2_2.state) {
            default: {
                throw new IllegalStateException("Resuming into unknown state");
            }
            case 0: {
                var1_1 = (ConsControl)var2_2.o0;
                var3_3 = (FuncState)var2_2.o1;
                var4_4 = (int)var2_2.l0;
                var5_5 = (ExpDesc)var2_2.o2;
                var6_6 = (ExpDesc)var2_2.o3;
                v0 = this;
                v1 = null;
                v2 = var2_2.child;
                ** continue;
            }
            case 1: {
                var1_1 = (ConsControl)var2_2.o0;
                var3_3 = (FuncState)var2_2.o1;
                var4_4 = (int)var2_2.l0;
                var5_5 = (ExpDesc)var2_2.o2;
                var6_6 = (ExpDesc)var2_2.o3;
                v3 = this;
                v4 = null;
                v5 = var2_2.child;
                ** continue;
            }
            case 2: {
                var1_1 = (ConsControl)var2_2.o0;
                var3_3 = (FuncState)var2_2.o1;
                var4_4 = (int)var2_2.l0;
                var5_5 = (ExpDesc)var2_2.o2;
                var6_6 = (ExpDesc)var2_2.o3;
                v6 = this;
                v7 = 0;
                v8 = var2_2.child;
                ** continue;
            }
            case 3: 
        }
        var1_1 = (ConsControl)var2_2.o0;
        var3_3 = (FuncState)var2_2.o1;
        var4_4 = (int)var2_2.l0;
        var6_6 = (ExpDesc)var2_2.o2;
        var7_7 = (int)var2_2.l1;
        v9 = this;
        v10 = null;
        v11 = var2_2.child;
        ** while (true)
        catch (Pause v12) {
            var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
            v12.pushState((UnwindState)var2_2);
            var2_2.state = 0;
            var2_2.o0 = var1_1;
            var2_2.o1 = var3_3;
            var2_2.l0 = var4_4;
            var2_2.o2 = var5_5;
            var2_2.o3 = var6_6;
            throw v12;
        }
        catch (Pause v13) {
            var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
            v13.pushState((UnwindState)var2_2);
            var2_2.state = 1;
            var2_2.o0 = var1_1;
            var2_2.o1 = var3_3;
            var2_2.l0 = var4_4;
            var2_2.o2 = var5_5;
            var2_2.o3 = var6_6;
            throw v13;
        }
        catch (Pause v14) {
            var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
            v14.pushState((UnwindState)var2_2);
            var2_2.state = 2;
            var2_2.o0 = var1_1;
            var2_2.o1 = var3_3;
            var2_2.l0 = var4_4;
            var2_2.o2 = var5_5;
            var2_2.o3 = var6_6;
            throw v14;
        }
        catch (Pause v15) {
            var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
            v15.pushState((UnwindState)var2_2);
            var2_2.state = 3;
            var2_2.o0 = var1_1;
            var2_2.o1 = var3_3;
            var2_2.l0 = var4_4;
            var2_2.o2 = var6_6;
            var2_2.l1 = var7_7;
            throw v15;
        }
    }

    void closeListField(FuncState fs, ConsControl cc) throws CompileException {
        if (cc.v.kind == ExpKind.VVOID) {
            return;
        }
        fs.exp2NextReg(cc.v);
        cc.v.kind = ExpKind.VVOID;
        if (cc.toStore == 50) {
            fs.setList(cc.table.info, cc.arraySize, cc.toStore);
            cc.toStore = 0;
        }
    }

    void lastListField(FuncState fs, ConsControl cc) throws CompileException {
        if (cc.toStore == 0) {
            return;
        }
        if (cc.v.kind.hasMultiRet()) {
            fs.setMultiRet(cc.v);
            fs.setList(cc.table.info, cc.arraySize, -1);
            --cc.arraySize;
        } else {
            if (cc.v.kind != ExpKind.VVOID) {
                fs.exp2NextReg(cc.v);
            }
            fs.setList(cc.table.info, cc.arraySize, cc.toStore);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void listField(ConsControl consControl, Object object) throws CompileException, LuaError, Pause {
        Object object2;
        ExpDesc expDesc;
        void cc;
        Parser parser;
        if (object == null) {
            parser = this;
            expDesc = cc.v;
            object2 = null;
        } else {
            object = (UnwindState$L0O4)object;
            if (((UnwindState$L0O4)object).state != 0) {
                throw new IllegalStateException("Resuming into unknown state");
            }
            consControl = (ConsControl)((UnwindState$L0O4)object).o0;
            parser = this;
            expDesc = null;
            object2 = ((UnwindState)object).child;
        }
        try {
            parser.expression(expDesc, object2);
            this.checkLimit(this.fs, cc.arraySize, 0x7FFFFFFD, "items in a constructor");
            ++cc.arraySize;
            ++cc.toStore;
            return;
        }
        catch (Pause pause) {
            object = UnwindState$L0O4.getOrCreate(object);
            pause.pushState((UnwindState)object);
            ((UnwindState)object).state = 0;
            ((UnwindState$L0O4)object).o0 = consControl;
            throw pause;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void field(ConsControl var1_1, Object var2_2) throws CompileException, LuaError, Pause {
        block26: {
            if (var2_2 != null) break block26;
            switch (this.lexer.token.token()) {
                case 288: {
                    v0 = this.lexer;
                    v1 = null;
lbl6:
                    // 2 sources

                    while (true) {
                        if (v0.lookahead(v1).token() == 61) ** GOTO lbl38
                        v2 = this;
                        v3 = cc;
                        v4 = null;
                        ** GOTO lbl34
                        break;
                    }
                }
                case 91: {
                    v5 = this;
                    v6 = cc;
                    v7 = null;
                    ** GOTO lbl45
                }
                default: {
                    v8 = this;
                    v9 = cc;
                    v10 = null;
                    break;
                }
            }
            ** GOTO lbl49
        }
        var2_2 = (UnwindState$L0O4)var2_2;
        switch (var2_2.state) {
            default: {
                throw new IllegalStateException("Resuming into unknown state");
            }
            case 0: {
                var1_1 = (ConsControl)var2_2.o0;
                v0 = this.lexer;
                v1 = var2_2.child;
                ** continue;
            }
lbl34:
            // 2 sources

            while (true) {
                v2.listField(v3, v4);
                return;
                break;
            }
lbl38:
            // 1 sources

            v11 = this;
            v12 = cc;
            v13 = null;
lbl41:
            // 2 sources

            while (true) {
                v11.recordField(v12, v13);
                return;
                break;
            }
lbl45:
            // 2 sources

            while (true) {
                v5.recordField(v6, v7);
                return;
                break;
            }
lbl49:
            // 2 sources

            while (true) {
                try {}
                catch (Pause v14) {
                    var2_2 = UnwindState$L0O4.getOrCreate(var2_2);
                    v14.pushState((UnwindState)var2_2);
                    var2_2.state = 4;
                    throw v14;
                }
                ** GOTO lbl78
                break;
            }
            catch (Pause v15) {
                var2_2 = UnwindState$L0O4.getOrCreate(var2_2);
                v15.pushState((UnwindState)var2_2);
                var2_2.state = 3;
                throw v15;
            }
            catch (Pause v16) {
                var2_2 = UnwindState$L0O4.getOrCreate(var2_2);
                v16.pushState((UnwindState)var2_2);
                var2_2.state = 2;
                throw v16;
            }
            catch (Pause v17) {
                var2_2 = UnwindState$L0O4.getOrCreate(var2_2);
                v17.pushState((UnwindState)var2_2);
                var2_2.state = 1;
                throw v17;
            }
            catch (Pause v18) {
                var2_2 = UnwindState$L0O4.getOrCreate(var2_2);
                v18.pushState((UnwindState)var2_2);
                var2_2.state = 0;
                var2_2.o0 = var1_1;
                throw v18;
            }
lbl78:
            // 1 sources

            v8.listField(v9, v10);
            return;
            case 1: {
                v2 = this;
                v3 = null;
                v4 = var2_2.child;
                ** continue;
            }
            case 2: {
                v11 = this;
                v12 = null;
                v13 = var2_2.child;
                ** continue;
            }
            case 3: {
                v5 = this;
                v6 = null;
                v7 = var2_2.child;
                ** continue;
            }
            case 4: 
        }
        v8 = this;
        v9 = null;
        v10 = var2_2.child;
        ** while (true)
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void constructor(ExpDesc var1_1, Object var2_2) throws CompileException, LuaError, Pause {
        block26: {
            block25: {
                block22: {
                    block24: {
                        block23: {
                            if (var2_2 == null) {
                                fs = this.fs;
                                line = this.lexer.token.line();
                                pc = fs.codeABC(11, 0, 0, 0);
                                cc = new ConsControl((ExpDesc)t);
                                t.init(ExpKind.VRELOCABLE, pc);
                                cc.v.init(ExpKind.VVOID, 0);
                                fs.exp2NextReg((ExpDesc)t);
                                v0 = this;
                                v1 = 123;
                                v2 = null;
lbl12:
                                // 2 sources

                                while (true) {
                                    v0.checkNext(v1, v2);
lbl15:
                                    // 3 sources

                                    while (true) {
                                        if (!Parser.$assertionsDisabled && cc.v.kind != ExpKind.VVOID && cc.toStore <= 0) {
                                            throw new AssertionError();
                                        }
                                        if (this.lexer.token.token() == 125) break block22;
                                        this.closeListField(fs, cc);
                                        v3 = this;
                                        v4 = cc;
                                        v5 = null;
lbl23:
                                        // 2 sources

                                        while (true) {
                                            v3.field(v4, v5);
                                            v6 = this;
                                            v7 = 44;
                                            v8 = null;
                                            break block23;
                                            break;
                                        }
                                        break;
                                    }
                                    break;
                                }
                            }
                            var2_2 = (UnwindState$L4O4)var2_2;
                            switch (var2_2.state) {
                                default: {
                                    throw new IllegalStateException("Resuming into unknown state");
                                }
                                case 0: {
                                    var3_3 = (FuncState)var2_2.o0;
                                    var4_4 = (int)var2_2.l0;
                                    var5_5 = (int)var2_2.l1;
                                    var6_6 = (ConsControl)var2_2.o1;
                                    v0 = this;
                                    v1 = 0;
                                    v2 = var2_2.child;
                                    ** continue;
                                }
                                catch (Pause v9) {
                                    var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                                    v9.pushState((UnwindState)var2_2);
                                    var2_2.state = 0;
                                    var2_2.o0 = var3_3;
                                    var2_2.l0 = var4_4;
                                    var2_2.l1 = var5_5;
                                    var2_2.o1 = var6_6;
                                    throw v9;
                                }
                                case 1: {
                                    var3_3 = (FuncState)var2_2.o0;
                                    var4_4 = (int)var2_2.l0;
                                    var5_5 = (int)var2_2.l1;
                                    var6_6 = (ConsControl)var2_2.o1;
                                    v3 = this;
                                    v4 = null;
                                    v5 = var2_2.child;
                                    ** continue;
                                }
                                case 2: {
                                    var3_3 = (FuncState)var2_2.o0;
                                    var4_4 = (int)var2_2.l0;
                                    var5_5 = (int)var2_2.l1;
                                    var6_6 = (ConsControl)var2_2.o1;
                                    v6 = this;
                                    v7 = 0;
                                    v8 = var2_2.child;
                                    break;
                                }
                                case 3: {
                                    var3_3 = (FuncState)var2_2.o0;
                                    var4_4 = (int)var2_2.l0;
                                    var5_5 = (int)var2_2.l1;
                                    var6_6 = (ConsControl)var2_2.o1;
                                    v10 = this;
                                    v11 = 0;
                                    v12 = var2_2.child;
                                    break block24;
                                }
                                case 4: {
                                    var3_3 = (FuncState)var2_2.o0;
                                    var5_5 = (int)var2_2.l0;
                                    var6_6 = (ConsControl)var2_2.o1;
                                    v13 = this;
                                    v14 = 0;
                                    v15 = 0;
                                    v16 = 0;
                                    v17 = var2_2.child;
                                    break block25;
                                }
                            }
                        }
                        try {
                            if (v6.testNext(v7, v8)) ** GOTO lbl15
                            v10 = this;
                            v11 = 59;
                            v12 = null;
                        }
                        catch (Pause v18) {
                            var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                            v18.pushState((UnwindState)var2_2);
                            var2_2.state = 2;
                            var2_2.o0 = var3_3;
                            var2_2.l0 = var4_4;
                            var2_2.l1 = var5_5;
                            var2_2.o1 = var6_6;
                            throw v18;
                        }
                    }
                    try {
                        if (!v10.testNext(v11, v12)) ** break;
                        ** continue;
                    }
                    catch (Pause v19) {
                        var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                        v19.pushState((UnwindState)var2_2);
                        var2_2.state = 3;
                        var2_2.o0 = var3_3;
                        var2_2.l0 = var4_4;
                        var2_2.l1 = var5_5;
                        var2_2.o1 = var6_6;
                        throw v19;
                    }
                }
                v13 = this;
                v14 = 125;
                v15 = 123;
                v16 = line;
                v17 = null;
            }
            try {}
            catch (Pause v20) {
                var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                v20.pushState((UnwindState)var2_2);
                var2_2.state = 4;
                var2_2.o0 = var3_3;
                var2_2.l0 = var5_5;
                var2_2.o1 = var6_6;
                throw v20;
            }
            break block26;
            catch (Pause v21) {
                var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                v21.pushState((UnwindState)var2_2);
                var2_2.state = 1;
                var2_2.o0 = var3_3;
                var2_2.l0 = var4_4;
                var2_2.l1 = var5_5;
                var2_2.o1 = var6_6;
                throw v21;
            }
        }
        v13.checkMatch(v14, v15, v16, v17);
        this.lastListField(fs, cc);
        insn = fs.code[pc];
        insn = LuaC.SETARG_B(insn, Parser.luaO_int2fb(cc.arraySize));
        fs.code[pc] = insn = LuaC.SETARG_C(insn, Parser.luaO_int2fb(cc.hashSize));
    }

    private static int luaO_int2fb(int x) {
        int e = 0;
        while (x >= 16) {
            x = x + 1 >> 1;
            ++e;
        }
        if (x < 8) {
            return x;
        }
        return e + 1 << 3 | x - 8;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parlist(Object var1_1) throws CompileException, LuaError, Pause {
        block18: {
            block19: {
                block17: {
                    if (var1_1 != null) ** GOTO lbl16
                    fs = this.fs;
                    numParams = 0;
                    if (this.lexer.token.token() == 41) break block18;
lbl5:
                    // 2 sources

                    while (true) {
                        switch (this.lexer.token.token()) {
                            case 288: {
                                v0 = this;
                                v1 = this;
                                v2 = null;
lbl11:
                                // 2 sources

                                while (true) {
                                    v0.newLocal(v1.strCheckName(v2));
                                    ++numParams;
                                    ** break;
                                    break;
                                }
                            }
lbl16:
                            // 1 sources

                            var1_1 = (UnwindState$L4O4)var1_1;
                            switch (var1_1.state) {
                                default: {
                                    throw new IllegalStateException("Resuming into unknown state");
                                }
                                case 0: {
                                    var2_2 = (FuncState)var1_1.o0;
                                    var3_3 = (int)var1_1.l0;
                                    v0 = this;
                                    v1 = this;
                                    v2 = var1_1.child;
                                    ** continue;
                                }
                                case 1: {
                                    var2_2 = (FuncState)var1_1.o0;
                                    var3_3 = (int)var1_1.l0;
                                    v3 = this.lexer;
                                    v4 = var1_1.child;
                                    ** GOTO lbl45
                                }
                                case 2: {
                                    var2_2 = (FuncState)var1_1.o0;
                                    var3_3 = (int)var1_1.l0;
                                    v5 = this;
                                    v6 = 0;
                                    v7 = var1_1.child;
                                    break;
                                }
                            }
                            break block17;
                            case 280: {
                                v3 = this.lexer;
                                v4 = null;
lbl45:
                                // 3 sources

                                v3.nextToken(v4);
                                fs.isVararg = true;
                                ** break;
                            }
                        }
                        break;
                    }
                    throw this.syntaxError("<name> or " + Parser.LUA_QL("...") + " expected");
lbl49:
                    // 2 sources

                    if (fs.isVararg) break block18;
                    v5 = this;
                    v6 = 44;
                    v7 = null;
                }
                try {}
                catch (Pause v8) {
                    var1_1 = UnwindState$L4O4.getOrCreate(var1_1);
                    v8.pushState((UnwindState)var1_1);
                    var1_1.state = 2;
                    var1_1.o0 = var2_2;
                    var1_1.l0 = var3_3;
                    throw v8;
                }
                break block19;
                catch (Pause v9) {
                    var1_1 = UnwindState$L4O4.getOrCreate(var1_1);
                    v9.pushState((UnwindState)var1_1);
                    var1_1.state = 1;
                    var1_1.o0 = var2_2;
                    var1_1.l0 = var3_3;
                    throw v9;
                }
                catch (Pause v10) {
                    var1_1 = UnwindState$L4O4.getOrCreate(var1_1);
                    v10.pushState((UnwindState)var1_1);
                    var1_1.state = 0;
                    var1_1.o0 = var2_2;
                    var1_1.l0 = var3_3;
                    throw v10;
                }
            }
            ** while (v5.testNext((int)v6, (Object)v7))
        }
        this.adjustLocalVars(numParams);
        fs.numParams = fs.activeVariableCount;
        fs.reserveRegs(fs.activeVariableCount);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void body(ExpDesc var1_1, boolean var2_2, int var3_3, Object var4_4) throws CompileException, LuaError, Pause {
        if (var4_4 == null) {
            newFuncState = this.openFunc();
            newFuncState.lineDefined = line;
            v0 = this;
            v1 = 40;
            v2 = null;
lbl7:
            // 2 sources

            while (true) {
                v0.checkNext(v1, v2);
                if (needSelf != false) {
                    this.newLocal("self");
                    this.adjustLocalVars(1);
                }
                v3 = this;
                v4 = null;
lbl15:
                // 2 sources

                while (true) {
                    v3.parlist(v4);
                    v5 = this;
                    v6 = 41;
                    v7 = null;
lbl21:
                    // 2 sources

                    while (true) {
                        v5.checkNext(v6, v7);
                        v8 = this;
                        v9 = null;
lbl26:
                        // 2 sources

                        while (true) {
                            v8.statementList(v9);
                            newFuncState.lastLineDefined = this.lexer.token.line();
                            v10 = this;
                            v11 = 262;
                            v12 = 265;
                            v13 = line;
                            v14 = null;
lbl35:
                            // 2 sources

                            while (true) {
                                v10.checkMatch(v11, v12, v13, v14);
                                proto = this.closeFunc();
                                this.codeClosure(proto, (ExpDesc)e);
                                return;
                                break;
                            }
                            break;
                        }
                        break;
                    }
                    break;
                }
                break;
            }
        }
        var4_4 = (UnwindState$L4O4)var4_4;
        switch (var4_4.state) {
            default: {
                throw new IllegalStateException("Resuming into unknown state");
            }
            case 0: {
                var1_1 = (ExpDesc)var4_4.o0;
                var2_2 = (int)var4_4.l0;
                var3_3 = (int)var4_4.l1;
                var5_5 = (FuncState)var4_4.o1;
                v0 = this;
                v1 = 0;
                v2 = var4_4.child;
                ** continue;
            }
            case 1: {
                var1_1 = (ExpDesc)var4_4.o0;
                var3_3 = (int)var4_4.l0;
                var5_5 = (FuncState)var4_4.o1;
                v3 = this;
                v4 = var4_4.child;
                ** continue;
            }
            case 2: {
                var1_1 = (ExpDesc)var4_4.o0;
                var3_3 = (int)var4_4.l0;
                var5_5 = (FuncState)var4_4.o1;
                v5 = this;
                v6 = 0;
                v7 = var4_4.child;
                ** continue;
            }
            case 3: {
                var1_1 = (ExpDesc)var4_4.o0;
                var3_3 = (int)var4_4.l0;
                var5_5 = (FuncState)var4_4.o1;
                v8 = this;
                v9 = var4_4.child;
                ** continue;
            }
            case 4: 
        }
        var1_1 = (ExpDesc)var4_4.o0;
        v10 = this;
        v11 = 0;
        v12 = 0;
        v13 = 0;
        v14 = var4_4.child;
        ** while (true)
        catch (Pause v15) {
            var4_4 = UnwindState$L4O4.getOrCreate(var4_4);
            v15.pushState((UnwindState)var4_4);
            var4_4.state = 0;
            var4_4.o0 = var1_1;
            var4_4.l0 = (long)var2_2;
            var4_4.l1 = var3_3;
            var4_4.o1 = var5_5;
            throw v15;
        }
        catch (Pause v16) {
            var4_4 = UnwindState$L4O4.getOrCreate(var4_4);
            v16.pushState((UnwindState)var4_4);
            var4_4.state = 1;
            var4_4.o0 = var1_1;
            var4_4.l0 = var3_3;
            var4_4.o1 = var5_5;
            throw v16;
        }
        catch (Pause v17) {
            var4_4 = UnwindState$L4O4.getOrCreate(var4_4);
            v17.pushState((UnwindState)var4_4);
            var4_4.state = 2;
            var4_4.o0 = var1_1;
            var4_4.l0 = var3_3;
            var4_4.o1 = var5_5;
            throw v17;
        }
        catch (Pause v18) {
            var4_4 = UnwindState$L4O4.getOrCreate(var4_4);
            v18.pushState((UnwindState)var4_4);
            var4_4.state = 3;
            var4_4.o0 = var1_1;
            var4_4.l0 = var3_3;
            var4_4.o1 = var5_5;
            throw v18;
        }
        catch (Pause v19) {
            var4_4 = UnwindState$L4O4.getOrCreate(var4_4);
            v19.pushState((UnwindState)var4_4);
            var4_4.state = 4;
            var4_4.o0 = var1_1;
            throw v19;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int expList1(ExpDesc var1_1, Object var2_2) throws CompileException, LuaError, Pause {
        if (var2_2 == null) {
            n = 1;
            v0 = this;
            v1 = v;
            v2 = null;
lbl6:
            // 2 sources

            while (true) {
                v0.expression(v1, v2);
                block12: while (true) {
                    v3 = this;
                    v4 = 44;
                    v5 = null;
lbl13:
                    // 2 sources

                    while (true) {
                        if (!v3.testNext(v4, v5)) return n;
                        this.fs.exp2NextReg((ExpDesc)v);
                        v6 = this;
                        v7 = v;
                        v8 = null;
lbl20:
                        // 2 sources

                        while (true) {
                            v6.expression(v7, v8);
                            ++n;
                            continue block12;
                            break;
                        }
                        break;
                    }
                    break;
                }
                break;
            }
        }
        var2_2 = (UnwindState$L4O4)var2_2;
        switch (var2_2.state) {
            default: {
                throw new IllegalStateException("Resuming into unknown state");
            }
            case 0: {
                var1_1 = (ExpDesc)var2_2.o0;
                var3_3 = (int)var2_2.l0;
                v0 = this;
                v1 = null;
                v2 = var2_2.child;
                ** continue;
            }
            case 1: {
                var1_1 = (ExpDesc)var2_2.o0;
                var3_3 = (int)var2_2.l0;
                v3 = this;
                v4 = 0;
                v5 = var2_2.child;
                ** continue;
            }
            case 2: 
        }
        var1_1 = (ExpDesc)var2_2.o0;
        var3_3 = (int)var2_2.l0;
        v6 = this;
        v7 = null;
        v8 = var2_2.child;
        ** while (true)
        catch (Pause v9) {
            var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
            v9.pushState((UnwindState)var2_2);
            var2_2.state = 0;
            var2_2.o0 = var1_1;
            var2_2.l0 = var3_3;
            throw v9;
        }
        catch (Pause v10) {
            var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
            v10.pushState((UnwindState)var2_2);
            var2_2.state = 1;
            var2_2.o0 = var1_1;
            var2_2.l0 = var3_3;
            throw v10;
        }
        catch (Pause v11) {
            var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
            v11.pushState((UnwindState)var2_2);
            var2_2.state = 2;
            var2_2.o0 = var1_1;
            var2_2.l0 = var3_3;
            throw v11;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void funcArgs(ExpDesc var1_1, Object var2_2) throws CompileException, LuaError, Pause {
        block31: {
            if (var2_2 != null) break block31;
            fs = this.fs;
            args = new ExpDesc();
            position = this.lexer.token.position();
            line = this.lexer.token.line();
            block5 : switch (this.lexer.token.token()) {
                case 40: {
                    v0 = this.lexer;
                    v1 = null;
lbl10:
                    // 2 sources

                    while (true) {
                        v0.nextToken(v1);
                        if (this.lexer.token.token() != 41) ** GOTO lbl16
                        args.kind = ExpKind.VVOID;
                        ** GOTO lbl24
lbl16:
                        // 1 sources

                        v2 = this;
                        v3 = args;
                        v4 = null;
lbl19:
                        // 2 sources

                        while (true) {
                            v2.expList1(v3, v4);
                            fs.setMultiRet(args);
lbl24:
                            // 2 sources

                            v5 = this;
                            v6 = 41;
                            v7 = 40;
                            v8 = line;
                            v9 = null;
lbl29:
                            // 2 sources

                            while (true) {
                                v5.checkMatch(v6, v7, v8, v9);
                                break block5;
                                break;
                            }
                            break;
                        }
                        break;
                    }
                }
                case 123: {
                    v10 = this;
                    v11 = args;
                    v12 = null;
lbl37:
                    // 2 sources

                    while (true) {
                        v10.constructor(v11, v12);
                        break block5;
                        break;
                    }
                }
                case 289: {
                    this.codeString(args, this.lexer.token.stringContents());
                    v13 = this.lexer;
                    v14 = null;
lbl45:
                    // 2 sources

                    while (true) {
                        v13.nextToken(v14);
                        break block5;
                        break;
                    }
                }
                default: {
                    throw this.syntaxError("function arguments expected");
                }
            }
            if (!Parser.$assertionsDisabled && f.kind != ExpKind.VNONRELOC) {
                throw new AssertionError();
            }
            base = f.info;
            if (args.kind.hasMultiRet()) {
                nArgs = -1;
            } else {
                if (args.kind != ExpKind.VVOID) {
                    fs.exp2NextReg(args);
                }
                nArgs = fs.freeReg - (base + 1);
            }
            f.init(ExpKind.VCALL, fs.codeABCAt(29, base, nArgs + 1, 2, position));
            fs.freeReg = base + 1;
            return;
        }
        var2_2 = (UnwindState$L4O4)var2_2;
        switch (var2_2.state) {
            default: {
                throw new IllegalStateException("Resuming into unknown state");
            }
            case 0: {
                var1_1 = (ExpDesc)var2_2.o0;
                var3_3 = (FuncState)var2_2.o1;
                var4_4 = (ExpDesc)var2_2.o2;
                var5_5 = var2_2.l0;
                var7_6 = (int)var2_2.l1;
                v0 = this.lexer;
                v1 = var2_2.child;
                ** continue;
            }
            case 1: {
                var1_1 = (ExpDesc)var2_2.o0;
                var3_3 = (FuncState)var2_2.o1;
                var4_4 = (ExpDesc)var2_2.o2;
                var5_5 = var2_2.l0;
                var7_6 = (int)var2_2.l1;
                v2 = this;
                v3 = null;
                v4 = var2_2.child;
                ** continue;
            }
            case 2: {
                var1_1 = (ExpDesc)var2_2.o0;
                var3_3 = (FuncState)var2_2.o1;
                var4_4 = (ExpDesc)var2_2.o2;
                var5_5 = var2_2.l0;
                v5 = this;
                v6 = 0;
                v7 = 0;
                v8 = 0;
                v9 = var2_2.child;
                ** continue;
            }
            case 3: {
                var1_1 = (ExpDesc)var2_2.o0;
                var3_3 = (FuncState)var2_2.o1;
                var4_4 = (ExpDesc)var2_2.o2;
                var5_5 = var2_2.l0;
                v10 = this;
                v11 = null;
                v12 = var2_2.child;
                ** continue;
            }
            case 4: 
        }
        var1_1 = (ExpDesc)var2_2.o0;
        var3_3 = (FuncState)var2_2.o1;
        var4_4 = (ExpDesc)var2_2.o2;
        var5_5 = var2_2.l0;
        v13 = this.lexer;
        v14 = var2_2.child;
        ** while (true)
        catch (Pause v15) {
            var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
            v15.pushState((UnwindState)var2_2);
            var2_2.state = 0;
            var2_2.o0 = var1_1;
            var2_2.o1 = var3_3;
            var2_2.o2 = var4_4;
            var2_2.l0 = var5_5;
            var2_2.l1 = var7_6;
            throw v15;
        }
        catch (Pause v16) {
            var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
            v16.pushState((UnwindState)var2_2);
            var2_2.state = 1;
            var2_2.o0 = var1_1;
            var2_2.o1 = var3_3;
            var2_2.o2 = var4_4;
            var2_2.l0 = var5_5;
            var2_2.l1 = var7_6;
            throw v16;
        }
        catch (Pause v17) {
            var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
            v17.pushState((UnwindState)var2_2);
            var2_2.state = 2;
            var2_2.o0 = var1_1;
            var2_2.o1 = var3_3;
            var2_2.o2 = var4_4;
            var2_2.l0 = var5_5;
            throw v17;
        }
        catch (Pause v18) {
            var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
            v18.pushState((UnwindState)var2_2);
            var2_2.state = 3;
            var2_2.o0 = var1_1;
            var2_2.o1 = var3_3;
            var2_2.o2 = var4_4;
            var2_2.l0 = var5_5;
            throw v18;
        }
        catch (Pause v19) {
            var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
            v19.pushState((UnwindState)var2_2);
            var2_2.state = 4;
            var2_2.o0 = var1_1;
            var2_2.o1 = var3_3;
            var2_2.o2 = var4_4;
            var2_2.l0 = var5_5;
            throw v19;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void primaryExpression(ExpDesc var1_1, Object var2_2) throws CompileException, LuaError, Pause {
        if (var2_2 == null) {
            block4 : switch (this.lexer.token.token()) {
                case 40: {
                    line = this.lexer.token.line();
                    v0 = this.lexer;
                    v1 = null;
lbl7:
                    // 2 sources

                    while (true) {
                        v0.nextToken(v1);
                        v2 = this;
                        v3 = v;
                        v4 = null;
lbl13:
                        // 2 sources

                        while (true) {
                            v2.expression(v3, v4);
                            v5 = this;
                            v6 = 41;
                            v7 = 40;
                            v8 = line;
                            v9 = null;
lbl21:
                            // 2 sources

                            while (true) {
                                v5.checkMatch(v6, v7, v8, v9);
                                this.fs.dischargeVars((ExpDesc)v);
                                break block4;
                                break;
                            }
                            break;
                        }
                        break;
                    }
                }
                case 288: {
                    v10 = this;
                    v11 = v;
                    v12 = null;
lbl30:
                    // 2 sources

                    while (true) {
                        v10.singleVar(v11, v12);
                        break block4;
                        break;
                    }
                }
                default: {
                    throw this.syntaxError("unexpected symbol");
                }
            }
            return;
        }
        var2_2 = (UnwindState$L4O4)var2_2;
        switch (var2_2.state) {
            default: {
                throw new IllegalStateException("Resuming into unknown state");
            }
            case 0: {
                var1_1 = (ExpDesc)var2_2.o0;
                var3_3 = (int)var2_2.l0;
                v0 = this.lexer;
                v1 = var2_2.child;
                ** continue;
            }
            case 1: {
                var1_1 = (ExpDesc)var2_2.o0;
                var3_3 = (int)var2_2.l0;
                v2 = this;
                v3 = null;
                v4 = var2_2.child;
                ** continue;
            }
            case 2: {
                var1_1 = (ExpDesc)var2_2.o0;
                v5 = this;
                v6 = 0;
                v7 = 0;
                v8 = 0;
                v9 = var2_2.child;
                ** continue;
            }
            case 3: 
        }
        v10 = this;
        v11 = null;
        v12 = var2_2.child;
        ** while (true)
        catch (Pause v13) {
            var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
            v13.pushState((UnwindState)var2_2);
            var2_2.state = 0;
            var2_2.o0 = var1_1;
            var2_2.l0 = var3_3;
            throw v13;
        }
        catch (Pause v14) {
            var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
            v14.pushState((UnwindState)var2_2);
            var2_2.state = 1;
            var2_2.o0 = var1_1;
            var2_2.l0 = var3_3;
            throw v14;
        }
        catch (Pause v15) {
            var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
            v15.pushState((UnwindState)var2_2);
            var2_2.state = 2;
            var2_2.o0 = var1_1;
            throw v15;
        }
        catch (Pause v16) {
            var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
            v16.pushState((UnwindState)var2_2);
            var2_2.state = 3;
            throw v16;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void suffixedExpression(ExpDesc var1_1, Object var2_2) throws CompileException, LuaError, Pause {
        if (var2_2 != null) ** GOTO lbl19
        fs = this.fs;
        v0 = this;
        v1 = v;
        v2 = null;
        block29: while (true) {
            v0.primaryExpression(v1, v2);
lbl9:
            // 2 sources

            block30: while (true) {
                switch (this.lexer.token.token()) {
                    case 46: {
                        v3 = this;
                        v4 = v;
                        v5 = null;
lbl15:
                        // 2 sources

                        while (true) {
                            v3.fieldSelect(v4, v5);
                            continue block30;
                            break;
                        }
                    }
lbl19:
                    // 1 sources

                    var2_2 = (UnwindState$L4O4)var2_2;
                    switch (var2_2.state) {
                        default: {
                            throw new IllegalStateException("Resuming into unknown state");
                        }
                        case 0: {
                            var1_1 = (ExpDesc)var2_2.o0;
                            var3_3 = (FuncState)var2_2.o1;
                            v0 = this;
                            v1 = null;
                            v2 = var2_2.child;
                            continue block29;
                        }
                        catch (Pause v6) {
                            var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                            v6.pushState((UnwindState)var2_2);
                            var2_2.state = 0;
                            var2_2.o0 = var1_1;
                            var2_2.o1 = var3_3;
                            throw v6;
                        }
                        case 1: {
                            var1_1 = (ExpDesc)var2_2.o0;
                            var3_3 = (FuncState)var2_2.o1;
                            v3 = this;
                            v4 = null;
                            v5 = var2_2.child;
                            ** continue;
                        }
                        case 2: {
                            var1_1 = (ExpDesc)var2_2.o0;
                            var3_3 = (FuncState)var2_2.o1;
                            var4_4 = (ExpDesc)var2_2.o2;
                            var5_5 = var2_2.l0;
                            v7 = this;
                            v8 = null;
                            v9 = var2_2.child;
                            ** GOTO lbl91
                        }
                        case 3: {
                            var1_1 = (ExpDesc)var2_2.o0;
                            var3_3 = (FuncState)var2_2.o1;
                            var4_4 = (ExpDesc)var2_2.o2;
                            v10 = this.lexer;
                            v11 = var2_2.child;
                            ** GOTO lbl99
                        }
                        case 4: {
                            var1_1 = (ExpDesc)var2_2.o0;
                            var3_3 = (FuncState)var2_2.o1;
                            var4_4 = (ExpDesc)var2_2.o2;
                            v12 = this;
                            v13 = null;
                            v14 = var2_2.child;
                            ** GOTO lbl104
                        }
                        case 5: {
                            var1_1 = (ExpDesc)var2_2.o0;
                            var3_3 = (FuncState)var2_2.o1;
                            v15 = this;
                            v16 = null;
                            v17 = var2_2.child;
                            ** GOTO lbl110
                        }
                        case 6: {
                            var1_1 = (ExpDesc)var2_2.o0;
                            var3_3 = (FuncState)var2_2.o1;
                            v18 = this;
                            v19 = null;
                            v20 = var2_2.child;
                            break;
                        }
                    }
                    ** GOTO lbl-1000
                    case 91: {
                        key = new ExpDesc();
                        fs.exp2AnyRegUp((ExpDesc)v);
                        indexPos = this.lexer.token.position();
                        v7 = this;
                        v8 = key;
                        v9 = null;
lbl91:
                        // 3 sources

                        v7.yindex(v8, v9);
                        fs.indexed((ExpDesc)v, key, indexPos);
                        continue block30;
                    }
                    case 58: {
                        key = new ExpDesc();
                        v10 = this.lexer;
                        v11 = null;
lbl99:
                        // 3 sources

                        v10.nextToken(v11);
                        v12 = this;
                        v13 = key;
                        v14 = null;
lbl104:
                        // 3 sources

                        v12.checkName(v13, v14);
                        fs.self((ExpDesc)v, key);
                        v15 = this;
                        v16 = v;
                        v17 = null;
lbl110:
                        // 3 sources

                        v15.funcArgs(v16, v17);
                        continue block30;
                    }
                    case 40: 
                    case 123: 
                    case 289: {
                        fs.exp2NextReg((ExpDesc)v);
                        v18 = this;
                        v19 = v;
                        v20 = null;
lbl-1000:
                        // 2 sources

                        try {}
                        catch (Pause v21) {
                            var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                            v21.pushState((UnwindState)var2_2);
                            var2_2.state = 6;
                            var2_2.o0 = var1_1;
                            var2_2.o1 = var3_3;
                            throw v21;
                        }
                        break block29;
                    }
                    default: {
                        return;
                    }
                }
                catch (Pause v22) {
                    var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                    v22.pushState((UnwindState)var2_2);
                    var2_2.state = 5;
                    var2_2.o0 = var1_1;
                    var2_2.o1 = var3_3;
                    throw v22;
                }
                catch (Pause v23) {
                    var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                    v23.pushState((UnwindState)var2_2);
                    var2_2.state = 4;
                    var2_2.o0 = var1_1;
                    var2_2.o1 = var3_3;
                    var2_2.o2 = var4_4;
                    throw v23;
                }
                catch (Pause v24) {
                    var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                    v24.pushState((UnwindState)var2_2);
                    var2_2.state = 3;
                    var2_2.o0 = var1_1;
                    var2_2.o1 = var3_3;
                    var2_2.o2 = var4_4;
                    throw v24;
                }
                catch (Pause v25) {
                    var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                    v25.pushState((UnwindState)var2_2);
                    var2_2.state = 2;
                    var2_2.o0 = var1_1;
                    var2_2.o1 = var3_3;
                    var2_2.o2 = var4_4;
                    var2_2.l0 = var5_5;
                    throw v25;
                }
                catch (Pause v26) {
                    var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                    v26.pushState((UnwindState)var2_2);
                    var2_2.state = 1;
                    var2_2.o0 = var1_1;
                    var2_2.o1 = var3_3;
                    throw v26;
                }
                break;
            }
            break;
        }
        v18.funcArgs(v19, v20);
        ** while (true)
    }

    /*
     * Unable to fully structure code
     */
    private void simpleExpression(ExpDesc var1_1, Object var2_2) throws CompileException, LuaError, Pause {
        if (var2_2 == null) {
            switch (this.lexer.token.token()) {
                case 287: {
                    v.init(ExpKind.VKNUM, 0);
                    v.setNval(this.lexer.token.numberContents());
                    break;
                }
                case 289: {
                    this.codeString((ExpDesc)v, this.lexer.token.stringContents());
                    break;
                }
                case 270: {
                    v.init(ExpKind.VNIL, 0);
                    break;
                }
                case 276: {
                    v.init(ExpKind.VTRUE, 0);
                    break;
                }
                case 263: {
                    v.init(ExpKind.VFALSE, 0);
                    break;
                }
                case 280: {
                    fs = this.fs;
                    this.checkCondition(fs.isVararg, "cannot use " + Parser.LUA_QL("...") + " outside a vararg function");
                    v.init(ExpKind.VVARARG, fs.codeABC(38, 0, 1, 0));
                    break;
                }
                case 123: {
                    v0 = this;
                    v1 = v;
                    v2 = null;
lbl28:
                    // 2 sources

                    while (true) {
                        v0.constructor(v1, v2);
                        return;
                        break;
                    }
                }
                case 265: {
                    v3 = this.lexer;
                    v4 = null;
lbl35:
                    // 2 sources

                    while (true) {
                        v3.nextToken(v4);
                        v5 = this;
                        v6 = v;
                        v7 = false;
                        v8 = this.lexer.token.line();
                        v9 = null;
lbl43:
                        // 2 sources

                        while (true) {
                            v5.body(v6, v7, v8, v9);
                            return;
                            break;
                        }
                        break;
                    }
                }
                default: {
                    v10 = this;
                    v11 = v;
                    v12 = null;
lbl51:
                    // 2 sources

                    while (true) {
                        v10.suffixedExpression(v11, v12);
                        return;
                        break;
                    }
                }
            }
            v13 = this.lexer;
            v14 = null;
lbl57:
            // 2 sources

            while (true) {
                v13.nextToken(v14);
                return;
                break;
            }
        }
        var2_2 = (UnwindState$L0O4)var2_2;
        switch (var2_2.state) {
            default: {
                throw new IllegalStateException("Resuming into unknown state");
            }
            case 0: {
                var1_1 = (ExpDesc)var2_2.o0;
                v0 = this;
                v1 = null;
                v2 = var2_2.child;
                ** continue;
            }
            case 1: {
                var1_1 = (ExpDesc)var2_2.o0;
                v3 = this.lexer;
                v4 = var2_2.child;
                ** continue;
            }
            case 2: {
                var1_1 = (ExpDesc)var2_2.o0;
                v5 = this;
                v6 = null;
                v7 = false;
                v8 = 0;
                v9 = var2_2.child;
                ** continue;
            }
            case 3: {
                v10 = this;
                v11 = null;
                v12 = var2_2.child;
                ** continue;
            }
            case 4: 
        }
        v13 = this.lexer;
        v14 = var2_2.child;
        ** while (true)
        catch (Pause v15) {
            var2_2 = UnwindState$L0O4.getOrCreate(var2_2);
            v15.pushState((UnwindState)var2_2);
            var2_2.state = 0;
            var2_2.o0 = var1_1;
            throw v15;
        }
        catch (Pause v16) {
            var2_2 = UnwindState$L0O4.getOrCreate(var2_2);
            v16.pushState((UnwindState)var2_2);
            var2_2.state = 1;
            var2_2.o0 = var1_1;
            throw v16;
        }
        catch (Pause v17) {
            var2_2 = UnwindState$L0O4.getOrCreate(var2_2);
            v17.pushState((UnwindState)var2_2);
            var2_2.state = 2;
            var2_2.o0 = var1_1;
            throw v17;
        }
        catch (Pause v18) {
            var2_2 = UnwindState$L0O4.getOrCreate(var2_2);
            v18.pushState((UnwindState)var2_2);
            var2_2.state = 3;
            throw v18;
        }
        catch (Pause v19) {
            var2_2 = UnwindState$L0O4.getOrCreate(var2_2);
            v19.pushState((UnwindState)var2_2);
            var2_2.state = 4;
            throw v19;
        }
    }

    /*
     * Unable to fully structure code
     */
    private BinOpr subExpression(ExpDesc var1_1, int var2_2, Object var3_3) throws CompileException, LuaError, Pause {
        block23: {
            block24: {
                if (var3_3 != null) break block23;
                this.enterLevel();
                unop = UnOpr.ofToken(this.lexer.token.token());
                if (unop == null) break block24;
                opPosition = this.lexer.token.position();
                v0 = this.lexer;
                v1 = null;
lbl8:
                // 2 sources

                while (true) {
                    v0.nextToken(v1);
                    v2 = this;
                    v3 = v;
                    v4 = 8;
                    v5 = null;
lbl15:
                    // 2 sources

                    while (true) {
                        v2.subExpression(v3, v4, v5);
                        this.fs.prefix(unop, (ExpDesc)v, opPosition);
                        ** GOTO lbl28
                        break;
                    }
                    break;
                }
            }
            v6 = this;
            v7 = v;
            v8 = null;
lbl25:
            // 2 sources

            while (true) {
                v6.simpleExpression(v7, v8);
lbl28:
                // 2 sources

                binop = BinOpr.ofToken(this.lexer.token.token());
                block20: while (binop != null && binop.left > limit) {
                    position = this.lexer.token.position();
                    v9 = this.lexer;
                    v10 = null;
lbl33:
                    // 2 sources

                    while (true) {
                        v9.nextToken(v10);
                        this.fs.infix(binop, (ExpDesc)v);
                        v2 = new ExpDesc();
                        v11 = this;
                        v12 = v2;
                        v13 = binop.right;
                        v14 = null;
lbl42:
                        // 2 sources

                        while (true) {
                            nextop = v11.subExpression(v12, v13, v14);
                            this.fs.posfix(binop, (ExpDesc)v, v2, position);
                            binop = nextop;
                            continue block20;
                            break;
                        }
                        break;
                    }
                }
                this.leaveLevel();
                return binop;
            }
        }
        var3_3 = (UnwindState$L4O4)var3_3;
        switch (var3_3.state) {
            default: {
                throw new IllegalStateException("Resuming into unknown state");
            }
            case 0: {
                var1_1 = (ExpDesc)var3_3.o0;
                var2_2 = (int)var3_3.l0;
                var4_4 = (UnOpr)var3_3.o1;
                var5_5 = var3_3.l1;
                v0 = this.lexer;
                v1 = var3_3.child;
                ** continue;
            }
            case 1: {
                var1_1 = (ExpDesc)var3_3.o0;
                var2_2 = (int)var3_3.l0;
                var4_4 = (UnOpr)var3_3.o1;
                var5_5 = var3_3.l1;
                v2 = this;
                v3 = null;
                v4 = 0;
                v5 = var3_3.child;
                ** continue;
            }
            case 2: {
                var1_1 = (ExpDesc)var3_3.o0;
                var2_2 = (int)var3_3.l0;
                v6 = this;
                v7 = null;
                v8 = var3_3.child;
                ** continue;
            }
            case 3: {
                var1_1 = (ExpDesc)var3_3.o0;
                var2_2 = (int)var3_3.l0;
                var7_6 = (BinOpr)var3_3.o1;
                var8_7 = var3_3.l1;
                v9 = this.lexer;
                v10 = var3_3.child;
                ** continue;
            }
            case 4: 
        }
        var1_1 = (ExpDesc)var3_3.o0;
        var2_2 = (int)var3_3.l0;
        var7_6 = (BinOpr)var3_3.o1;
        var8_7 = var3_3.l1;
        var10_8 = (ExpDesc)var3_3.o2;
        v11 = this;
        v12 = null;
        v13 = 0;
        v14 = var3_3.child;
        ** while (true)
        catch (Pause v15) {
            var3_3 = UnwindState$L4O4.getOrCreate(var3_3);
            v15.pushState((UnwindState)var3_3);
            var3_3.state = 0;
            var3_3.o0 = var1_1;
            var3_3.l0 = var2_2;
            var3_3.o1 = var4_4;
            var3_3.l1 = var5_5;
            throw v15;
        }
        catch (Pause v16) {
            var3_3 = UnwindState$L4O4.getOrCreate(var3_3);
            v16.pushState((UnwindState)var3_3);
            var3_3.state = 1;
            var3_3.o0 = var1_1;
            var3_3.l0 = var2_2;
            var3_3.o1 = var4_4;
            var3_3.l1 = var5_5;
            throw v16;
        }
        catch (Pause v17) {
            var3_3 = UnwindState$L4O4.getOrCreate(var3_3);
            v17.pushState((UnwindState)var3_3);
            var3_3.state = 2;
            var3_3.o0 = var1_1;
            var3_3.l0 = var2_2;
            throw v17;
        }
        catch (Pause v18) {
            var3_3 = UnwindState$L4O4.getOrCreate(var3_3);
            v18.pushState((UnwindState)var3_3);
            var3_3.state = 3;
            var3_3.o0 = var1_1;
            var3_3.l0 = var2_2;
            var3_3.o1 = var7_6;
            var3_3.l1 = var8_7;
            throw v18;
        }
        catch (Pause v19) {
            var3_3 = UnwindState$L4O4.getOrCreate(var3_3);
            v19.pushState((UnwindState)var3_3);
            var3_3.state = 4;
            var3_3.o0 = var1_1;
            var3_3.l0 = var2_2;
            var3_3.o1 = var7_6;
            var3_3.l1 = var8_7;
            var3_3.o2 = var10_8;
            throw v19;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void expression(ExpDesc expDesc, Object object) throws CompileException, LuaError, Pause {
        Object object2;
        int n;
        Object v1;
        Parser parser;
        if (object == null) {
            void v;
            parser = this;
            v1 = v;
            n = 0;
            object2 = null;
        } else {
            object = (UnwindState)object;
            if (((UnwindState)object).state != 0) {
                throw new IllegalStateException("Resuming into unknown state");
            }
            parser = this;
            v1 = null;
            n = 0;
            object2 = ((UnwindState)object).child;
        }
        try {
            parser.subExpression(v1, n, object2);
        }
        catch (Pause pause) {
            object = UnwindState.getOrCreate(object);
            pause.pushState((UnwindState)object);
            ((UnwindState)object).state = 0;
            throw pause;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void block(Object object) throws CompileException, LuaError, Pause {
        Object object2;
        Parser parser;
        if (object == null) {
            this.enterBlock(this.fs, false);
            parser = this;
            object2 = null;
        } else {
            object = (UnwindState)object;
            if (((UnwindState)object).state != 0) {
                throw new IllegalStateException("Resuming into unknown state");
            }
            parser = this;
            object2 = ((UnwindState)object).child;
        }
        try {
            parser.statementList(object2);
            this.leaveBlock(this.fs);
            return;
        }
        catch (Pause pause) {
            object = UnwindState.getOrCreate(object);
            pause.pushState((UnwindState)object);
            ((UnwindState)object).state = 0;
            throw pause;
        }
    }

    private void checkConflict(LhsAssign lh, ExpDesc v) throws CompileException {
        FuncState fs = this.fs;
        int extra = fs.freeReg;
        boolean conflict = false;
        while (lh != null) {
            if (lh.v.kind == ExpKind.VINDEXED) {
                if (lh.v.tableType == v.kind && lh.v.info == v.info) {
                    conflict = true;
                    lh.v.tableType = ExpKind.VLOCAL;
                    lh.v.info = extra;
                }
                if (v.kind == ExpKind.VLOCAL && lh.v.aux == v.info) {
                    conflict = true;
                    lh.v.aux = extra;
                }
            }
            lh = lh.prev;
        }
        if (conflict) {
            int opcode = v.kind == ExpKind.VLOCAL ? 0 : 5;
            fs.codeABC(opcode, extra, v.info, 0);
            fs.reserveRegs(1);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void assignment(LhsAssign var1_1, int var2_2, Object var3_3) throws CompileException, LuaError, Pause {
        block26: {
            if (var3_3 != null) break block26;
            e = new ExpDesc();
            this.checkCondition(lh.v.kind.isVar(), "syntax error");
            v0 = this;
            v1 = 44;
            v2 = null;
lbl7:
            // 2 sources

            while (true) {
                block24: {
                    if (!v0.testNext(v1, v2)) break block24;
                    nv = new LhsAssign((LhsAssign)lh);
                    v3 = this;
                    v4 = nv.v;
                    v5 = null;
lbl14:
                    // 2 sources

                    while (true) {
                        v3.suffixedExpression(v4, v5);
                        if (nv.v.kind != ExpKind.VINDEXED) {
                            this.checkConflict((LhsAssign)lh, nv.v);
                        }
                        v6 = this;
                        v7 = nv;
                        v8 = nvars + true;
                        v9 = null;
lbl23:
                        // 2 sources

                        while (true) {
                            v6.assignment(v7, v8, v9);
                            ** GOTO lbl46
                            break;
                        }
                        break;
                    }
                }
                v10 = this;
                v11 = 61;
                v12 = null;
lbl31:
                // 2 sources

                while (true) {
                    v10.checkNext(v11, v12);
                    v13 = this;
                    v14 = e;
                    v15 = null;
lbl37:
                    // 2 sources

                    while (true) {
                        block25: {
                            nexps = v13.expList1(v14, v15);
                            if (nexps != nvars) {
                                this.adjustAssign((int)nvars, nexps, e);
                                break block25;
                            }
                            this.fs.setOneRet(e);
                            this.fs.storeVar(lh.v, e);
                            return;
                        }
                        e.init(ExpKind.VNONRELOC, this.fs.freeReg - 1);
                        this.fs.storeVar(lh.v, e);
                        return;
                    }
                    break;
                }
                break;
            }
        }
        var3_3 = (UnwindState$L4O4)var3_3;
        switch (var3_3.state) {
            default: {
                throw new IllegalStateException("Resuming into unknown state");
            }
            case 0: {
                var1_1 = (LhsAssign)var3_3.o0;
                var2_2 = (int)var3_3.l0;
                var4_4 = (ExpDesc)var3_3.o1;
                v0 = this;
                v1 = 0;
                v2 = var3_3.child;
                ** continue;
            }
            case 1: {
                var1_1 = (LhsAssign)var3_3.o0;
                var2_2 = (int)var3_3.l0;
                var4_4 = (ExpDesc)var3_3.o1;
                var5_5 = (LhsAssign)var3_3.o2;
                v3 = this;
                v4 = null;
                v5 = var3_3.child;
                ** continue;
            }
            case 2: {
                var1_1 = (LhsAssign)var3_3.o0;
                var4_4 = (ExpDesc)var3_3.o1;
                v6 = this;
                v7 = null;
                v8 = 0;
                v9 = var3_3.child;
                ** continue;
            }
            case 3: {
                var1_1 = (LhsAssign)var3_3.o0;
                var2_2 = (int)var3_3.l0;
                var4_4 = (ExpDesc)var3_3.o1;
                v10 = this;
                v11 = 0;
                v12 = var3_3.child;
                ** continue;
            }
            case 4: 
        }
        var1_1 = (LhsAssign)var3_3.o0;
        var2_2 = (int)var3_3.l0;
        var4_4 = (ExpDesc)var3_3.o1;
        v13 = this;
        v14 = null;
        v15 = var3_3.child;
        ** while (true)
        catch (Pause v16) {
            var3_3 = UnwindState$L4O4.getOrCreate(var3_3);
            v16.pushState((UnwindState)var3_3);
            var3_3.state = 0;
            var3_3.o0 = var1_1;
            var3_3.l0 = var2_2;
            var3_3.o1 = var4_4;
            throw v16;
        }
        catch (Pause v17) {
            var3_3 = UnwindState$L4O4.getOrCreate(var3_3);
            v17.pushState((UnwindState)var3_3);
            var3_3.state = 1;
            var3_3.o0 = var1_1;
            var3_3.l0 = var2_2;
            var3_3.o1 = var4_4;
            var3_3.o2 = var5_5;
            throw v17;
        }
        catch (Pause v18) {
            var3_3 = UnwindState$L4O4.getOrCreate(var3_3);
            v18.pushState((UnwindState)var3_3);
            var3_3.state = 2;
            var3_3.o0 = var1_1;
            var3_3.o1 = var4_4;
            throw v18;
        }
        catch (Pause v19) {
            var3_3 = UnwindState$L4O4.getOrCreate(var3_3);
            v19.pushState((UnwindState)var3_3);
            var3_3.state = 3;
            var3_3.o0 = var1_1;
            var3_3.l0 = var2_2;
            var3_3.o1 = var4_4;
            throw v19;
        }
        catch (Pause v20) {
            var3_3 = UnwindState$L4O4.getOrCreate(var3_3);
            v20.pushState((UnwindState)var3_3);
            var3_3.state = 4;
            var3_3.o0 = var1_1;
            var3_3.l0 = var2_2;
            var3_3.o1 = var4_4;
            throw v20;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int cond(Object object) throws CompileException, LuaError, Pause {
        ExpDesc expDesc;
        Object object2;
        ExpDesc expDesc2;
        Parser parser;
        ExpDesc v;
        if (object == null) {
            v = new ExpDesc();
            parser = this;
            expDesc2 = v;
            object2 = null;
        } else {
            object = (UnwindState$L0O4)object;
            if (((UnwindState$L0O4)object).state != 0) {
                throw new IllegalStateException("Resuming into unknown state");
            }
            expDesc = (ExpDesc)((UnwindState$L0O4)object).o0;
            parser = this;
            expDesc2 = null;
            object2 = ((UnwindState)object).child;
        }
        try {
            parser.expression(expDesc2, object2);
            if (v.kind == ExpKind.VNIL) {
                v.kind = ExpKind.VFALSE;
            }
            this.fs.goIfTrue(v);
            return v.f.value;
        }
        catch (Pause pause) {
            object = UnwindState$L0O4.getOrCreate(object);
            pause.pushState((UnwindState)object);
            ((UnwindState)object).state = 0;
            ((UnwindState$L0O4)object).o0 = expDesc;
            throw pause;
        }
    }

    private void gotoLabel(int pc, int line, LuaString label) throws CompileException {
        int g = this.newLabelEntry(this.pendingGotos, label, line, pc);
        this.findLabel(g);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void breakStmt(int n, Object object) throws CompileException, LuaError, Pause {
        int n2;
        Object object2;
        Lex lex;
        int line;
        if (object == null) {
            line = this.lexer.token.line();
            lex = this.lexer;
            object2 = null;
        } else {
            object = (UnwindState$L4O0)object;
            if (((UnwindState$L4O0)object).state != 0) {
                throw new IllegalStateException("Resuming into unknown state");
            }
            n = (int)((UnwindState$L4O0)object).l0;
            n2 = (int)((UnwindState$L4O0)object).l1;
            lex = this.lexer;
            object2 = ((UnwindState)object).child;
        }
        try {
            void pc;
            lex.nextToken(object2);
            this.gotoLabel((int)pc, line, this.lexer.newString("break"));
            return;
        }
        catch (Pause pause) {
            object = UnwindState$L4O0.getOrCreate(object);
            pause.pushState((UnwindState)object);
            ((UnwindState)object).state = 0;
            ((UnwindState$L4O0)object).l0 = n;
            ((UnwindState$L4O0)object).l1 = n2;
            throw pause;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void gotoStat(int var1_1, Object var2_2) throws CompileException, LuaError, Pause {
        if (var2_2 == null) {
            line = this.lexer.token.line();
            v0 = this.lexer;
            v1 = null;
lbl5:
            // 2 sources

            while (true) {
                v0.nextToken(v1);
                v2 = this;
                v3 = pc;
                v4 = line;
                v5 = this;
                v6 = null;
lbl13:
                // 2 sources

                while (true) {
                    v2.gotoLabel(v3, v4, v5.strCheckName(v6));
                    return;
                    break;
                }
                break;
            }
        }
        var2_2 = (UnwindState$L4O0)var2_2;
        switch (var2_2.state) {
            default: {
                throw new IllegalStateException("Resuming into unknown state");
            }
            case 0: {
                var1_1 = (int)var2_2.l0;
                var3_3 = (int)var2_2.l1;
                v0 = this.lexer;
                v1 = var2_2.child;
                ** continue;
            }
            case 1: 
        }
        var1_1 = (int)var2_2.l0;
        var3_3 = (int)var2_2.l1;
        v2 = this;
        v3 = var1_1;
        v4 = var3_3;
        v5 = this;
        v6 = var2_2.child;
        ** while (true)
        catch (Pause v7) {
            var2_2 = UnwindState$L4O0.getOrCreate(var2_2);
            v7.pushState((UnwindState)var2_2);
            var2_2.state = 0;
            var2_2.l0 = var1_1;
            var2_2.l1 = var3_3;
            throw v7;
        }
        catch (Pause v8) {
            var2_2 = UnwindState$L4O0.getOrCreate(var2_2);
            v8.pushState((UnwindState)var2_2);
            var2_2.state = 1;
            var2_2.l0 = var1_1;
            var2_2.l1 = var3_3;
            throw v8;
        }
    }

    private void checkRepeated(LuaString name) throws CompileException {
        for (int i = this.fs.firstLabel; i < this.activeLabels.size(); ++i) {
            LabelDesc label = this.activeLabels.get(i);
            if (label.name != name) continue;
            throw this.semError("label '" + String.valueOf(name) + "' already defined on line " + label.line);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void skipNoOpStatements(Object var1_1) throws CompileException, LuaError, Pause {
        block5: {
            if (var1_1 == null) break block5;
            var1_1 = (UnwindState)var1_1;
            if (var1_1.state != 0) {
                throw new IllegalStateException("Resuming into unknown state");
            }
            v0 = this;
            v1 = var1_1.child;
            ** GOTO lbl14
        }
        while (true) {
            if (this.lexer.token.token() != 59) {
                if (this.lexer.token.token() != 285) return;
            }
            v0 = this;
            v1 = null;
lbl14:
            // 2 sources

            try {
                v0.statement(v1);
            }
            catch (Pause v2) {
                var1_1 = UnwindState.getOrCreate(var1_1);
                v2.pushState((UnwindState)var1_1);
                var1_1.state = 0;
                throw v2;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void labelStat(LuaString var1_1, int var2_2, Object var3_3) throws CompileException, LuaError, Pause {
        if (var3_3 == null) {
            this.checkRepeated((LuaString)name);
            v0 = this;
            v1 = 285;
            v2 = null;
lbl6:
            // 2 sources

            while (true) {
                v0.checkNext(v1, v2);
                label = this.newLabelEntry(this.activeLabels, (LuaString)name, (int)line, this.fs.getLabel());
                v3 = this;
                v4 = null;
lbl12:
                // 2 sources

                while (true) {
                    v3.skipNoOpStatements(v4);
                    if (this.blockFollow(false)) {
                        this.activeLabels.get((int)label).activeVariables = this.fs.block.activeVariableCount;
                    }
                    this.findGotos(this.activeLabels.get(label));
                    return;
                    break;
                }
                break;
            }
        }
        var3_3 = (UnwindState$L4O4)var3_3;
        switch (var3_3.state) {
            default: {
                throw new IllegalStateException("Resuming into unknown state");
            }
            case 0: {
                var1_1 = (LuaString)var3_3.o0;
                var2_2 = (int)var3_3.l0;
                v0 = this;
                v1 = 0;
                v2 = var3_3.child;
                ** continue;
            }
            case 1: 
        }
        var4_4 = (int)var3_3.l0;
        v3 = this;
        v4 = var3_3.child;
        ** while (true)
        catch (Pause v5) {
            var3_3 = UnwindState$L4O4.getOrCreate(var3_3);
            v5.pushState((UnwindState)var3_3);
            var3_3.state = 0;
            var3_3.o0 = var1_1;
            var3_3.l0 = var2_2;
            throw v5;
        }
        catch (Pause v6) {
            var3_3 = UnwindState$L4O4.getOrCreate(var3_3);
            v6.pushState((UnwindState)var3_3);
            var3_3.state = 1;
            var3_3.l0 = var4_4;
            throw v6;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void whileStmt(Object var1_1) throws CompileException, LuaError, Pause {
        if (var1_1 == null) {
            line = this.lexer.token.line();
            v0 = this.lexer;
            v1 = null;
lbl5:
            // 2 sources

            while (true) {
                v0.nextToken(v1);
                fs = this.fs;
                bl = new FuncState.BlockCnt();
                whileInit = fs.getLabel();
                v2 = this;
                v3 = null;
lbl13:
                // 2 sources

                while (true) {
                    contExit = v2.cond(v3);
                    this.enterBlock(fs, bl, true);
                    v4 = this;
                    v5 = 259;
                    v6 = null;
lbl20:
                    // 2 sources

                    while (true) {
                        v4.checkNext(v5, v6);
                        v7 = this;
                        v8 = null;
lbl25:
                        // 2 sources

                        while (true) {
                            v7.block(v8);
                            fs.patchList(fs.jump(), whileInit);
                            v9 = this;
                            v10 = 262;
                            v11 = 278;
                            v12 = line;
                            v13 = null;
lbl34:
                            // 2 sources

                            while (true) {
                                v9.checkMatch(v10, v11, v12, v13);
                                this.leaveBlock(fs);
                                fs.patchToHere(contExit);
                                return;
                                break;
                            }
                            break;
                        }
                        break;
                    }
                    break;
                }
                break;
            }
        }
        var1_1 = (UnwindState$L4O4)var1_1;
        switch (var1_1.state) {
            default: {
                throw new IllegalStateException("Resuming into unknown state");
            }
            case 0: {
                var2_2 = (int)var1_1.l0;
                v0 = this.lexer;
                v1 = var1_1.child;
                ** continue;
            }
            case 1: {
                var2_2 = (int)var1_1.l0;
                var3_3 = (FuncState)var1_1.o0;
                var4_4 = (FuncState.BlockCnt)var1_1.o1;
                var5_5 = (int)var1_1.l1;
                v2 = this;
                v3 = var1_1.child;
                ** continue;
            }
            case 2: {
                var2_2 = (int)var1_1.l0;
                var3_3 = (FuncState)var1_1.o0;
                var5_5 = (int)var1_1.l1;
                var6_6 = (int)var1_1.l2;
                v4 = this;
                v5 = 0;
                v6 = var1_1.child;
                ** continue;
            }
            case 3: {
                var2_2 = (int)var1_1.l0;
                var3_3 = (FuncState)var1_1.o0;
                var5_5 = (int)var1_1.l1;
                var6_6 = (int)var1_1.l2;
                v7 = this;
                v8 = var1_1.child;
                ** continue;
            }
            case 4: 
        }
        var3_3 = (FuncState)var1_1.o0;
        var6_6 = (int)var1_1.l0;
        v9 = this;
        v10 = 0;
        v11 = 0;
        v12 = 0;
        v13 = var1_1.child;
        ** while (true)
        catch (Pause v14) {
            var1_1 = UnwindState$L4O4.getOrCreate(var1_1);
            v14.pushState((UnwindState)var1_1);
            var1_1.state = 0;
            var1_1.l0 = var2_2;
            throw v14;
        }
        catch (Pause v15) {
            var1_1 = UnwindState$L4O4.getOrCreate(var1_1);
            v15.pushState((UnwindState)var1_1);
            var1_1.state = 1;
            var1_1.l0 = var2_2;
            var1_1.o0 = var3_3;
            var1_1.o1 = var4_4;
            var1_1.l1 = var5_5;
            throw v15;
        }
        catch (Pause v16) {
            var1_1 = UnwindState$L4O4.getOrCreate(var1_1);
            v16.pushState((UnwindState)var1_1);
            var1_1.state = 2;
            var1_1.l0 = var2_2;
            var1_1.o0 = var3_3;
            var1_1.l1 = var5_5;
            var1_1.l2 = var6_6;
            throw v16;
        }
        catch (Pause v17) {
            var1_1 = UnwindState$L4O4.getOrCreate(var1_1);
            v17.pushState((UnwindState)var1_1);
            var1_1.state = 3;
            var1_1.l0 = var2_2;
            var1_1.o0 = var3_3;
            var1_1.l1 = var5_5;
            var1_1.l2 = var6_6;
            throw v17;
        }
        catch (Pause v18) {
            var1_1 = UnwindState$L4O4.getOrCreate(var1_1);
            v18.pushState((UnwindState)var1_1);
            var1_1.state = 4;
            var1_1.o0 = var3_3;
            var1_1.l0 = var6_6;
            throw v18;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void repeatStmt(Object var1_1) throws CompileException, LuaError, Pause {
        if (var1_1 == null) {
            line = this.lexer.token.line();
            v0 = this.lexer;
            v1 = null;
lbl5:
            // 2 sources

            while (true) {
                v0.nextToken(v1);
                fs = this.fs;
                repeatInit = fs.getLabel();
                bl1 = new FuncState.BlockCnt();
                bl2 = new FuncState.BlockCnt();
                this.enterBlock(fs, bl1, true);
                this.enterBlock(fs, bl2, false);
                v2 = this;
                v3 = null;
lbl16:
                // 2 sources

                while (true) {
                    v2.statementList(v3);
                    v4 = this;
                    v5 = 277;
                    v6 = 273;
                    v7 = line;
                    v8 = null;
lbl24:
                    // 2 sources

                    while (true) {
                        v4.checkMatch(v5, v6, v7, v8);
                        v9 = this;
                        v10 = null;
lbl29:
                        // 2 sources

                        while (true) {
                            condexit = v9.cond(v10);
                            if (bl2.upval) {
                                fs.patchClose(condexit, bl2.activeVariableCount);
                            }
                            this.leaveBlock(fs);
                            fs.patchList(condexit, repeatInit);
                            this.leaveBlock(fs);
                            return;
                            break;
                        }
                        break;
                    }
                    break;
                }
                break;
            }
        }
        var1_1 = (UnwindState$L4O4)var1_1;
        switch (var1_1.state) {
            default: {
                throw new IllegalStateException("Resuming into unknown state");
            }
            case 0: {
                var2_2 = (int)var1_1.l0;
                v0 = this.lexer;
                v1 = var1_1.child;
                ** continue;
            }
            case 1: {
                var2_2 = (int)var1_1.l0;
                var3_3 = (FuncState)var1_1.o0;
                var4_4 = (int)var1_1.l1;
                var6_6 = (FuncState.BlockCnt)var1_1.o1;
                v2 = this;
                v3 = var1_1.child;
                ** continue;
            }
            case 2: {
                var3_3 = (FuncState)var1_1.o0;
                var4_4 = (int)var1_1.l0;
                var6_6 = (FuncState.BlockCnt)var1_1.o1;
                v4 = this;
                v5 = 0;
                v6 = 0;
                v7 = 0;
                v8 = var1_1.child;
                ** continue;
            }
            case 3: 
        }
        var3_3 = (FuncState)var1_1.o0;
        var4_4 = (int)var1_1.l0;
        var6_6 = (FuncState.BlockCnt)var1_1.o1;
        v9 = this;
        v10 = var1_1.child;
        ** while (true)
        catch (Pause v11) {
            var1_1 = UnwindState$L4O4.getOrCreate(var1_1);
            v11.pushState((UnwindState)var1_1);
            var1_1.state = 0;
            var1_1.l0 = var2_2;
            throw v11;
        }
        catch (Pause v12) {
            var1_1 = UnwindState$L4O4.getOrCreate(var1_1);
            v12.pushState((UnwindState)var1_1);
            var1_1.state = 1;
            var1_1.l0 = var2_2;
            var1_1.o0 = var3_3;
            var1_1.l1 = var4_4;
            var1_1.o1 = var6_6;
            throw v12;
        }
        catch (Pause v13) {
            var1_1 = UnwindState$L4O4.getOrCreate(var1_1);
            v13.pushState((UnwindState)var1_1);
            var1_1.state = 2;
            var1_1.o0 = var3_3;
            var1_1.l0 = var4_4;
            var1_1.o1 = var6_6;
            throw v13;
        }
        catch (Pause v14) {
            var1_1 = UnwindState$L4O4.getOrCreate(var1_1);
            v14.pushState((UnwindState)var1_1);
            var1_1.state = 3;
            var1_1.o0 = var3_3;
            var1_1.l0 = var4_4;
            var1_1.o1 = var6_6;
            throw v14;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void exp1(Object object) throws CompileException, LuaError, Pause {
        ExpDesc expDesc;
        Object object2;
        ExpDesc expDesc2;
        Parser parser;
        ExpDesc e;
        if (object == null) {
            e = new ExpDesc();
            parser = this;
            expDesc2 = e;
            object2 = null;
        } else {
            object = (UnwindState$L0O4)object;
            if (((UnwindState$L0O4)object).state != 0) {
                throw new IllegalStateException("Resuming into unknown state");
            }
            expDesc = (ExpDesc)((UnwindState$L0O4)object).o0;
            parser = this;
            expDesc2 = null;
            object2 = ((UnwindState)object).child;
        }
        try {
            parser.expression(expDesc2, object2);
            this.fs.exp2NextReg(e);
            return;
        }
        catch (Pause pause) {
            object = UnwindState$L0O4.getOrCreate(object);
            pause.pushState((UnwindState)object);
            ((UnwindState)object).state = 0;
            ((UnwindState$L0O4)object).o0 = expDesc;
            throw pause;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void forBody(int var1_1, long var2_2, int var4_3, boolean var5_4, Object var6_5) throws CompileException, LuaError, Pause {
        if (var6_5 == null) {
            bl = new FuncState.BlockCnt();
            fs = this.fs;
            this.adjustLocalVars(3);
            v0 = this;
            v1 = 259;
            v2 = null;
lbl8:
            // 2 sources

            while (true) {
                v0.checkNext(v1, v2);
                prep = isNum != false ? fs.codeAsBx(33, (int)base, -1) : fs.jump();
                this.enterBlock(fs, bl, false);
                this.adjustLocalVars((int)nvars);
                fs.reserveRegs((int)nvars);
                v3 = this;
                v4 = null;
lbl17:
                // 2 sources

                while (true) {
                    block12: {
                        v3.block(v4);
                        this.leaveBlock(fs);
                        fs.patchToHere(prep);
                        if (isNum != false) {
                            endFor = fs.codeAsBxAt(32, (int)base, -1, (long)position);
                            break block12;
                        }
                        fs.codeABCAt(34, (int)base, 0, (int)nvars, (long)position);
                        endFor = fs.codeAsBxAt(35, (int)(base + 2), -1, (long)position);
                    }
                    fs.patchList(endFor, prep + 1);
                    return;
                }
                break;
            }
        }
        var6_5 = (UnwindState$L8O4)var6_5;
        switch (var6_5.state) {
            default: {
                throw new IllegalStateException("Resuming into unknown state");
            }
            case 0: {
                var1_1 = (int)var6_5.l0;
                var2_2 = var6_5.l1;
                var4_3 = (int)var6_5.l2;
                var5_4 = (int)var6_5.l3;
                var7_6 = (FuncState.BlockCnt)var6_5.o0;
                var8_7 = (FuncState)var6_5.o1;
                v0 = this;
                v1 = 0;
                v2 = var6_5.child;
                ** continue;
            }
            case 1: 
        }
        var1_1 = (int)var6_5.l0;
        var2_2 = var6_5.l1;
        var4_3 = (int)var6_5.l2;
        var5_4 = (int)var6_5.l3;
        var8_7 = (FuncState)var6_5.o0;
        var9_8 = (int)var6_5.l4;
        v3 = this;
        v4 = var6_5.child;
        ** while (true)
        catch (Pause v5) {
            var6_5 = UnwindState$L8O4.getOrCreate(var6_5);
            v5.pushState((UnwindState)var6_5);
            var6_5.state = 0;
            var6_5.l0 = var1_1;
            var6_5.l1 = var2_2;
            var6_5.l2 = var4_3;
            var6_5.l3 = (long)var5_4;
            var6_5.o0 = var7_6;
            var6_5.o1 = var8_7;
            throw v5;
        }
        catch (Pause v6) {
            var6_5 = UnwindState$L8O4.getOrCreate(var6_5);
            v6.pushState((UnwindState)var6_5);
            var6_5.state = 1;
            var6_5.l0 = var1_1;
            var6_5.l1 = var2_2;
            var6_5.l2 = var4_3;
            var6_5.l3 = (long)var5_4;
            var6_5.o0 = var8_7;
            var6_5.l4 = var9_8;
            throw v6;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void forNum(LuaString var1_1, long var2_2, Object var4_3) throws CompileException, LuaError, Pause {
        if (var4_3 == null) {
            fs = this.fs;
            base = fs.freeReg;
            this.newLocal("(for index)");
            this.newLocal("(for limit)");
            this.newLocal("(for step)");
            this.newLocal((LuaString)varName);
            v0 = this;
            v1 = 61;
            v2 = null;
lbl11:
            // 2 sources

            while (true) {
                v0.checkNext(v1, v2);
                v3 = this;
                v4 = null;
lbl16:
                // 2 sources

                while (true) {
                    v3.exp1(v4);
                    v5 = this;
                    v6 = 44;
                    v7 = null;
lbl22:
                    // 2 sources

                    while (true) {
                        v5.checkNext(v6, v7);
                        v8 = this;
                        v9 = null;
lbl27:
                        // 2 sources

                        while (true) {
                            v8.exp1(v9);
                            v10 = this;
                            v11 = 44;
                            v12 = null;
lbl33:
                            // 2 sources

                            while (true) {
                                block32: {
                                    block31: {
                                        if (!v10.testNext(v11, v12)) break block31;
                                        v13 = this;
                                        v14 = null;
lbl38:
                                        // 2 sources

                                        while (true) {
                                            v13.exp1(v14);
                                            break block32;
                                            break;
                                        }
                                    }
                                    fs.codeK(fs.freeReg, fs.numberK(LuaInteger.valueOf(1)));
                                    fs.reserveRegs(1);
                                }
                                v15 = this;
                                v16 = base;
                                v17 = position;
                                v18 = 1;
                                v19 = true;
                                v20 = null;
lbl53:
                                // 2 sources

                                while (true) {
                                    v15.forBody(v16, v17, v18, v19, v20);
                                    return;
                                    break;
                                }
                                break;
                            }
                            break;
                        }
                        break;
                    }
                    break;
                }
                break;
            }
        }
        var4_3 = (UnwindState$L4O4)var4_3;
        switch (var4_3.state) {
            default: {
                throw new IllegalStateException("Resuming into unknown state");
            }
            case 0: {
                var2_2 = var4_3.l0;
                var5_4 = (FuncState)var4_3.o0;
                var6_5 = (int)var4_3.l1;
                v0 = this;
                v1 = 0;
                v2 = var4_3.child;
                ** continue;
            }
            case 1: {
                var2_2 = var4_3.l0;
                var5_4 = (FuncState)var4_3.o0;
                var6_5 = (int)var4_3.l1;
                v3 = this;
                v4 = var4_3.child;
                ** continue;
            }
            case 2: {
                var2_2 = var4_3.l0;
                var5_4 = (FuncState)var4_3.o0;
                var6_5 = (int)var4_3.l1;
                v5 = this;
                v6 = 0;
                v7 = var4_3.child;
                ** continue;
            }
            case 3: {
                var2_2 = var4_3.l0;
                var5_4 = (FuncState)var4_3.o0;
                var6_5 = (int)var4_3.l1;
                v8 = this;
                v9 = var4_3.child;
                ** continue;
            }
            case 4: {
                var2_2 = var4_3.l0;
                var5_4 = (FuncState)var4_3.o0;
                var6_5 = (int)var4_3.l1;
                v10 = this;
                v11 = 0;
                v12 = var4_3.child;
                ** continue;
            }
            case 5: {
                var2_2 = var4_3.l0;
                var6_5 = (int)var4_3.l1;
                v13 = this;
                v14 = var4_3.child;
                ** continue;
            }
            case 6: 
        }
        v15 = this;
        v16 = 0;
        v17 = 0L;
        v18 = 0;
        v19 = false;
        v20 = var4_3.child;
        ** while (true)
        catch (Pause v21) {
            var4_3 = UnwindState$L4O4.getOrCreate(var4_3);
            v21.pushState((UnwindState)var4_3);
            var4_3.state = 0;
            var4_3.l0 = var2_2;
            var4_3.o0 = var5_4;
            var4_3.l1 = var6_5;
            throw v21;
        }
        catch (Pause v22) {
            var4_3 = UnwindState$L4O4.getOrCreate(var4_3);
            v22.pushState((UnwindState)var4_3);
            var4_3.state = 1;
            var4_3.l0 = var2_2;
            var4_3.o0 = var5_4;
            var4_3.l1 = var6_5;
            throw v22;
        }
        catch (Pause v23) {
            var4_3 = UnwindState$L4O4.getOrCreate(var4_3);
            v23.pushState((UnwindState)var4_3);
            var4_3.state = 2;
            var4_3.l0 = var2_2;
            var4_3.o0 = var5_4;
            var4_3.l1 = var6_5;
            throw v23;
        }
        catch (Pause v24) {
            var4_3 = UnwindState$L4O4.getOrCreate(var4_3);
            v24.pushState((UnwindState)var4_3);
            var4_3.state = 3;
            var4_3.l0 = var2_2;
            var4_3.o0 = var5_4;
            var4_3.l1 = var6_5;
            throw v24;
        }
        catch (Pause v25) {
            var4_3 = UnwindState$L4O4.getOrCreate(var4_3);
            v25.pushState((UnwindState)var4_3);
            var4_3.state = 4;
            var4_3.l0 = var2_2;
            var4_3.o0 = var5_4;
            var4_3.l1 = var6_5;
            throw v25;
        }
        catch (Pause v26) {
            var4_3 = UnwindState$L4O4.getOrCreate(var4_3);
            v26.pushState((UnwindState)var4_3);
            var4_3.state = 5;
            var4_3.l0 = var2_2;
            var4_3.l1 = var6_5;
            throw v26;
        }
        catch (Pause v27) {
            var4_3 = UnwindState$L4O4.getOrCreate(var4_3);
            v27.pushState((UnwindState)var4_3);
            var4_3.state = 6;
            throw v27;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void forList(LuaString var1_1, Object var2_2) throws CompileException, LuaError, Pause {
        block25: {
            block24: {
                block23: {
                    block22: {
                        block20: {
                            block21: {
                                if (var2_2 == null) {
                                    fs = this.fs;
                                    e = new ExpDesc();
                                    nvars = 4;
                                    base = fs.freeReg;
                                    this.newLocal("(for generator)");
                                    this.newLocal("(for state)");
                                    this.newLocal("(for control)");
                                    this.newLocal((LuaString)indexName);
lbl10:
                                    // 2 sources

                                    while (true) {
                                        v0 = this;
                                        v1 = 44;
                                        v2 = null;
lbl14:
                                        // 2 sources

                                        while (true) {
                                            if (!v0.testNext(v1, v2)) break block20;
                                            v3 = this;
                                            v4 = this;
                                            v5 = null;
                                            break block21;
                                            break;
                                        }
                                        break;
                                    }
                                }
                                var2_2 = (UnwindState$L4O4)var2_2;
                                switch (var2_2.state) {
                                    default: {
                                        throw new IllegalStateException("Resuming into unknown state");
                                    }
                                    case 0: {
                                        var3_3 = (FuncState)var2_2.o0;
                                        var4_4 = (ExpDesc)var2_2.o1;
                                        var5_5 = (int)var2_2.l0;
                                        var6_6 = (int)var2_2.l1;
                                        v0 = this;
                                        v1 = 0;
                                        v2 = var2_2.child;
                                        ** continue;
                                    }
                                    case 1: {
                                        var3_3 = (FuncState)var2_2.o0;
                                        var4_4 = (ExpDesc)var2_2.o1;
                                        var5_5 = (int)var2_2.l0;
                                        var6_6 = (int)var2_2.l1;
                                        v3 = this;
                                        v4 = this;
                                        v5 = var2_2.child;
                                        break;
                                    }
                                    case 2: {
                                        var3_3 = (FuncState)var2_2.o0;
                                        var4_4 = (ExpDesc)var2_2.o1;
                                        var5_5 = (int)var2_2.l0;
                                        var6_6 = (int)var2_2.l1;
                                        v6 = this;
                                        v7 = 0;
                                        v8 = var2_2.child;
                                        break block22;
                                    }
                                    case 3: {
                                        var3_3 = (FuncState)var2_2.o0;
                                        var4_4 = (ExpDesc)var2_2.o1;
                                        var5_5 = (int)var2_2.l0;
                                        var6_6 = (int)var2_2.l1;
                                        var7_7 = var2_2.l2;
                                        v9 = this;
                                        v10 = 3;
                                        v11 = this;
                                        v12 = null;
                                        v13 = var2_2.child;
                                        break block23;
                                    }
                                    case 4: {
                                        v14 = this;
                                        v15 = 0;
                                        v16 = 0L;
                                        v17 = 0;
                                        v18 = false;
                                        v19 = var2_2.child;
                                        break block24;
                                    }
                                }
                            }
                            try {
                                v3.newLocal(v4.strCheckName(v5));
                                ++nvars;
                                ** continue;
                            }
                            catch (Pause v20) {
                                var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                                v20.pushState((UnwindState)var2_2);
                                var2_2.state = 1;
                                var2_2.o0 = var3_3;
                                var2_2.o1 = var4_4;
                                var2_2.l0 = var5_5;
                                var2_2.l1 = var6_6;
                                throw v20;
                            }
                        }
                        v6 = this;
                        v7 = 268;
                        v8 = null;
                    }
                    try {
                        v6.checkNext(v7, v8);
                        position = this.lexer.token.position();
                        v9 = this;
                        v10 = 3;
                        v11 = this;
                        v12 = e;
                        v13 = null;
                    }
                    catch (Pause v21) {
                        var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                        v21.pushState((UnwindState)var2_2);
                        var2_2.state = 2;
                        var2_2.o0 = var3_3;
                        var2_2.o1 = var4_4;
                        var2_2.l0 = var5_5;
                        var2_2.l1 = var6_6;
                        throw v21;
                    }
                }
                try {
                    v9.adjustAssign(v10, v11.expList1(v12, v13), e);
                    fs.checkStack(3);
                    v14 = this;
                    v15 = base;
                    v16 = position;
                    v17 = nvars - 3;
                    v18 = false;
                    v19 = null;
                }
                catch (Pause v22) {
                    var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                    v22.pushState((UnwindState)var2_2);
                    var2_2.state = 3;
                    var2_2.o0 = var3_3;
                    var2_2.o1 = var4_4;
                    var2_2.l0 = var5_5;
                    var2_2.l1 = var6_6;
                    var2_2.l2 = var7_7;
                    throw v22;
                }
            }
            try {}
            catch (Pause v23) {
                var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                v23.pushState((UnwindState)var2_2);
                var2_2.state = 4;
                throw v23;
            }
            break block25;
            catch (Pause v24) {
                var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                v24.pushState((UnwindState)var2_2);
                var2_2.state = 0;
                var2_2.o0 = var3_3;
                var2_2.o1 = var4_4;
                var2_2.l0 = var5_5;
                var2_2.l1 = var6_6;
                throw v24;
            }
        }
        v14.forBody(v15, v16, v17, v18, v19);
    }

    /*
     * Unable to fully structure code
     */
    private void forStmt(Object var1_1) throws CompileException, LuaError, Pause {
        if (var1_1 == null) {
            position = this.lexer.token.position();
            v0 = this.lexer;
            v1 = null;
lbl5:
            // 2 sources

            while (true) {
                v0.nextToken(v1);
                fs = this.fs;
                bl = new FuncState.BlockCnt();
                this.enterBlock(fs, bl, true);
                v2 = this;
                v3 = null;
lbl13:
                // 2 sources

                while (true) {
                    varName = v2.strCheckName(v3);
                    block5 : switch (this.lexer.token.token()) {
                        case 61: {
                            v4 = this;
                            v5 = varName;
                            v6 = position;
                            v7 = null;
lbl22:
                            // 2 sources

                            while (true) {
                                v4.forNum(v5, v6, v7);
                                break block5;
                                break;
                            }
                        }
                        case 44: 
                        case 268: {
                            v8 = this;
                            v9 = varName;
                            v10 = null;
lbl30:
                            // 2 sources

                            while (true) {
                                v8.forList(v9, v10);
                                break block5;
                                break;
                            }
                        }
                        default: {
                            throw this.syntaxError(Parser.LUA_QL("=") + " or " + Parser.LUA_QL("in") + " expected");
                        }
                    }
                    v11 = this;
                    v12 = 262;
                    v13 = 264;
                    v14 = Lex.unpackLine(position);
                    v15 = null;
lbl41:
                    // 2 sources

                    while (true) {
                        v11.checkMatch(v12, v13, v14, v15);
                        this.leaveBlock(fs);
                        return;
                        break;
                    }
                    break;
                }
                break;
            }
        }
        var1_1 = (UnwindState$L4O4)var1_1;
        switch (var1_1.state) {
            default: {
                throw new IllegalStateException("Resuming into unknown state");
            }
            case 0: {
                var2_2 = var1_1.l0;
                v0 = this.lexer;
                v1 = var1_1.child;
                ** continue;
            }
            case 1: {
                var2_2 = var1_1.l0;
                var4_3 = (FuncState)var1_1.o0;
                v2 = this;
                v3 = var1_1.child;
                ** continue;
            }
            case 2: {
                var2_2 = var1_1.l0;
                var4_3 = (FuncState)var1_1.o0;
                v4 = this;
                v5 = null;
                v6 = 0L;
                v7 = var1_1.child;
                ** continue;
            }
            case 3: {
                var2_2 = var1_1.l0;
                var4_3 = (FuncState)var1_1.o0;
                v8 = this;
                v9 = null;
                v10 = var1_1.child;
                ** continue;
            }
            case 4: 
        }
        var4_3 = (FuncState)var1_1.o0;
        v11 = this;
        v12 = 0;
        v13 = 0;
        v14 = 0;
        v15 = var1_1.child;
        ** while (true)
        catch (Pause v16) {
            var1_1 = UnwindState$L4O4.getOrCreate(var1_1);
            v16.pushState((UnwindState)var1_1);
            var1_1.state = 0;
            var1_1.l0 = var2_2;
            throw v16;
        }
        catch (Pause v17) {
            var1_1 = UnwindState$L4O4.getOrCreate(var1_1);
            v17.pushState((UnwindState)var1_1);
            var1_1.state = 1;
            var1_1.l0 = var2_2;
            var1_1.o0 = var4_3;
            throw v17;
        }
        catch (Pause v18) {
            var1_1 = UnwindState$L4O4.getOrCreate(var1_1);
            v18.pushState((UnwindState)var1_1);
            var1_1.state = 2;
            var1_1.l0 = var2_2;
            var1_1.o0 = var4_3;
            throw v18;
        }
        catch (Pause v19) {
            var1_1 = UnwindState$L4O4.getOrCreate(var1_1);
            v19.pushState((UnwindState)var1_1);
            var1_1.state = 3;
            var1_1.l0 = var2_2;
            var1_1.o0 = var4_3;
            throw v19;
        }
        catch (Pause v20) {
            var1_1 = UnwindState$L4O4.getOrCreate(var1_1);
            v20.pushState((UnwindState)var1_1);
            var1_1.state = 4;
            var1_1.o0 = var4_3;
            throw v20;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void testThenBlock(IntPtr var1_1, Object var2_2) throws CompileException, LuaError, Pause {
        block40: {
            block39: {
                block37: {
                    block38: {
                        if (var2_2 != null) break block38;
                        v0 = this.lexer;
                        v1 = null;
lbl4:
                        // 2 sources

                        while (true) {
                            v0.nextToken(v1);
                            v = new ExpDesc();
                            v2 = this;
                            v3 = v;
                            v4 = null;
                            ** GOTO lbl22
                            break;
                        }
                    }
                    var2_2 = (UnwindState$L4O4)var2_2;
                    switch (var2_2.state) {
                        default: {
                            throw new IllegalStateException("Resuming into unknown state");
                        }
                        case 0: {
                            var1_1 = (IntPtr)var2_2.o0;
                            v0 = this.lexer;
                            v1 = var2_2.child;
                            ** continue;
                        }
lbl22:
                        // 2 sources

                        while (true) {
                            try {
                                v2.expression(v3, v4);
                                v5 = this;
                                v6 = 275;
                                v7 = null;
                            }
                            catch (Pause v23) {
                                var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                                v23.pushState((UnwindState)var2_2);
                                var2_2.state = 1;
                                var2_2.o0 = var1_1;
                                var2_2.o1 = var3_3;
                                throw v23;
                            }
lbl28:
                            // 2 sources

                            while (true) {
                                try {
                                    v5.checkNext(v6, v7);
                                    if (this.lexer.token.token() == 258) ** GOTO lbl38
                                    if (this.lexer.token.token() != 288) ** GOTO lbl106
                                    v8 = this;
                                    v9 = null;
                                }
                                catch (Pause v22) {
                                    var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                                    v22.pushState((UnwindState)var2_2);
                                    var2_2.state = 2;
                                    var2_2.o0 = var1_1;
                                    var2_2.o1 = var3_3;
                                    throw v22;
                                }
lbl35:
                                // 2 sources

                                while (true) {
                                    try {
                                        if (!v8.tryGoto(v9)) ** GOTO lbl106
                                    }
                                    catch (Pause v21) {
                                        var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                                        v21.pushState((UnwindState)var2_2);
                                        var2_2.state = 3;
                                        var2_2.o0 = var1_1;
                                        var2_2.o1 = var3_3;
                                        throw v21;
                                    }
lbl38:
                                    // 2 sources

                                    this.fs.goIfFalse(v);
                                    this.enterBlock(this.fs, false);
                                    if (this.lexer.token.token() == 258) {
                                        v10 = this;
                                        v11 = v.t.value;
                                        v12 = null;
lbl44:
                                        // 2 sources

                                        while (true) {
                                            v10.breakStmt(v11, v12);
lbl47:
                                            // 2 sources

                                            block31: while (true) {
                                                v13 = this;
                                                v14 = 59;
                                                v15 = null;
lbl51:
                                                // 2 sources

                                                while (true) {
                                                    if (v13.testNext(v14, v15)) continue block31;
                                                    if (this.blockFollow(false)) {
                                                        this.leaveBlock(this.fs);
                                                        return;
                                                    }
                                                    jumpFalse = this.fs.jump();
                                                    break block37;
                                                    break;
                                                }
                                                break;
                                            }
                                            break;
                                        }
                                    }
                                    v16 = this;
                                    v17 = v.t.value;
                                    v18 = null;
lbl62:
                                    // 2 sources

                                    while (true) {
                                        try {}
                                        catch (Pause v19) {
                                            var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                                            v19.pushState((UnwindState)var2_2);
                                            var2_2.state = 5;
                                            var2_2.o0 = var1_1;
                                            throw v19;
                                        }
                                        ** GOTO lbl104
                                        break;
                                    }
                                    catch (Pause v20) {
                                        var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                                        v20.pushState((UnwindState)var2_2);
                                        var2_2.state = 4;
                                        var2_2.o0 = var1_1;
                                        throw v20;
                                    }
                                    break;
                                }
                                break;
                            }
                            break;
                        }
                        catch (Pause v24) {
                            var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                            v24.pushState((UnwindState)var2_2);
                            var2_2.state = 0;
                            var2_2.o0 = var1_1;
                            throw v24;
                        }
lbl104:
                        // 1 sources

                        v16.gotoStat(v17, v18);
                        ** continue;
lbl106:
                        // 2 sources

                        this.fs.goIfTrue(v);
                        this.enterBlock(this.fs, false);
                        jumpFalse = v.f.value;
                        break block37;
                        case 1: {
                            var1_1 = (IntPtr)var2_2.o0;
                            var3_3 = (ExpDesc)var2_2.o1;
                            v2 = this;
                            v3 = null;
                            v4 = var2_2.child;
                            ** continue;
                        }
                        case 2: {
                            var1_1 = (IntPtr)var2_2.o0;
                            var3_3 = (ExpDesc)var2_2.o1;
                            v5 = this;
                            v6 = 0;
                            v7 = var2_2.child;
                            ** continue;
                        }
                        case 3: {
                            var1_1 = (IntPtr)var2_2.o0;
                            var3_3 = (ExpDesc)var2_2.o1;
                            v8 = this;
                            v9 = var2_2.child;
                            ** continue;
                        }
                        case 4: {
                            var1_1 = (IntPtr)var2_2.o0;
                            v10 = this;
                            v11 = 0;
                            v12 = var2_2.child;
                            ** continue;
                        }
                        case 5: {
                            var1_1 = (IntPtr)var2_2.o0;
                            v16 = this;
                            v17 = 0;
                            v18 = var2_2.child;
                            ** continue;
                        }
                        case 6: {
                            var1_1 = (IntPtr)var2_2.o0;
                            v13 = this;
                            v14 = 0;
                            v15 = var2_2.child;
                            ** continue;
                        }
                        case 7: 
                    }
                    var1_1 = (IntPtr)var2_2.o0;
                    var4_4 = (int)var2_2.l0;
                    v25 = this;
                    v26 = var2_2.child;
                    break block39;
                }
                v25 = this;
                v26 = null;
            }
            try {}
            catch (Pause v27) {
                var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                v27.pushState((UnwindState)var2_2);
                var2_2.state = 7;
                var2_2.o0 = var1_1;
                var2_2.l0 = var4_4;
                throw v27;
            }
            break block40;
            catch (Pause v28) {
                var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                v28.pushState((UnwindState)var2_2);
                var2_2.state = 6;
                var2_2.o0 = var1_1;
                throw v28;
            }
        }
        v25.statementList(v26);
        this.leaveBlock(this.fs);
        if (this.lexer.token.token() == 260 || this.lexer.token.token() == 261) {
            this.fs.concat((IntPtr)escapeList, this.fs.jump());
        }
        this.fs.patchToHere(jumpFalse);
    }

    /*
     * Unable to fully structure code
     */
    private void ifStat(Object var1_1) throws CompileException, LuaError, Pause {
        block23: {
            if (var1_1 != null) break block23;
            line = this.lexer.token.line();
            fs = this.fs;
            escapeList = new IntPtr(-1);
            v0 = this;
            v1 = escapeList;
            v2 = null;
lbl8:
            // 2 sources

            while (true) {
                v0.testThenBlock(v1, v2);
                block18: while (this.lexer.token.token() == 261) {
                    v3 = this;
                    v4 = escapeList;
                    v5 = null;
lbl15:
                    // 2 sources

                    while (true) {
                        v3.testThenBlock(v4, v5);
                        continue block18;
                        break;
                    }
                }
                v6 = this;
                v7 = 260;
                v8 = null;
lbl22:
                // 2 sources

                while (true) {
                    if (!v6.testNext(v7, v8)) ** GOTO lbl30
                    v9 = this;
                    v10 = null;
lbl27:
                    // 2 sources

                    while (true) {
                        v9.block(v10);
lbl30:
                        // 2 sources

                        v11 = this;
                        v12 = 262;
                        v13 = 267;
                        v14 = line;
                        v15 = null;
lbl35:
                        // 2 sources

                        while (true) {
                            v11.checkMatch(v12, v13, v14, v15);
                            fs.patchToHere(escapeList.value);
                            return;
                            break;
                        }
                        break;
                    }
                    break;
                }
                break;
            }
        }
        var1_1 = (UnwindState$L4O4)var1_1;
        switch (var1_1.state) {
            default: {
                throw new IllegalStateException("Resuming into unknown state");
            }
            case 0: {
                var2_2 = (int)var1_1.l0;
                var3_3 = (FuncState)var1_1.o0;
                var4_4 = (IntPtr)var1_1.o1;
                v0 = this;
                v1 = null;
                v2 = var1_1.child;
                ** continue;
            }
            case 1: {
                var2_2 = (int)var1_1.l0;
                var3_3 = (FuncState)var1_1.o0;
                var4_4 = (IntPtr)var1_1.o1;
                v3 = this;
                v4 = null;
                v5 = var1_1.child;
                ** continue;
            }
            case 2: {
                var2_2 = (int)var1_1.l0;
                var3_3 = (FuncState)var1_1.o0;
                var4_4 = (IntPtr)var1_1.o1;
                v6 = this;
                v7 = 0;
                v8 = var1_1.child;
                ** continue;
            }
            case 3: {
                var2_2 = (int)var1_1.l0;
                var3_3 = (FuncState)var1_1.o0;
                var4_4 = (IntPtr)var1_1.o1;
                v9 = this;
                v10 = var1_1.child;
                ** continue;
            }
            case 4: 
        }
        var3_3 = (FuncState)var1_1.o0;
        var4_4 = (IntPtr)var1_1.o1;
        v11 = this;
        v12 = 0;
        v13 = 0;
        v14 = 0;
        v15 = var1_1.child;
        ** while (true)
        catch (Pause v16) {
            var1_1 = UnwindState$L4O4.getOrCreate(var1_1);
            v16.pushState((UnwindState)var1_1);
            var1_1.state = 0;
            var1_1.l0 = var2_2;
            var1_1.o0 = var3_3;
            var1_1.o1 = var4_4;
            throw v16;
        }
        catch (Pause v17) {
            var1_1 = UnwindState$L4O4.getOrCreate(var1_1);
            v17.pushState((UnwindState)var1_1);
            var1_1.state = 1;
            var1_1.l0 = var2_2;
            var1_1.o0 = var3_3;
            var1_1.o1 = var4_4;
            throw v17;
        }
        catch (Pause v18) {
            var1_1 = UnwindState$L4O4.getOrCreate(var1_1);
            v18.pushState((UnwindState)var1_1);
            var1_1.state = 2;
            var1_1.l0 = var2_2;
            var1_1.o0 = var3_3;
            var1_1.o1 = var4_4;
            throw v18;
        }
        catch (Pause v19) {
            var1_1 = UnwindState$L4O4.getOrCreate(var1_1);
            v19.pushState((UnwindState)var1_1);
            var1_1.state = 3;
            var1_1.l0 = var2_2;
            var1_1.o0 = var3_3;
            var1_1.o1 = var4_4;
            throw v19;
        }
        catch (Pause v20) {
            var1_1 = UnwindState$L4O4.getOrCreate(var1_1);
            v20.pushState((UnwindState)var1_1);
            var1_1.state = 4;
            var1_1.o0 = var3_3;
            var1_1.o1 = var4_4;
            throw v20;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void localFunc(Object var1_1) throws CompileException, LuaError, Pause {
        if (var1_1 == null) {
            fs = this.fs;
            v0 = this;
            v1 = this;
            v2 = null;
lbl6:
            // 2 sources

            while (true) {
                v0.newLocal(v1.strCheckName(v2));
                this.adjustLocalVars(1);
                b = new ExpDesc();
                v3 = this;
                v4 = b;
                v5 = false;
                v6 = this.lexer.token.line();
                v7 = null;
lbl16:
                // 2 sources

                while (true) {
                    v3.body(v4, v5, v6, v7);
                    this.getLocal((FuncState)fs, (int)b.info).startpc = fs.pc;
                    return;
                    break;
                }
                break;
            }
        }
        var1_1 = (UnwindState$L0O4)var1_1;
        switch (var1_1.state) {
            default: {
                throw new IllegalStateException("Resuming into unknown state");
            }
            case 0: {
                var2_2 = (FuncState)var1_1.o0;
                v0 = this;
                v1 = this;
                v2 = var1_1.child;
                ** continue;
            }
            case 1: 
        }
        var2_2 = (FuncState)var1_1.o0;
        var3_3 = (ExpDesc)var1_1.o1;
        v3 = this;
        v4 = null;
        v5 = false;
        v6 = 0;
        v7 = var1_1.child;
        ** while (true)
        catch (Pause v8) {
            var1_1 = UnwindState$L0O4.getOrCreate(var1_1);
            v8.pushState((UnwindState)var1_1);
            var1_1.state = 0;
            var1_1.o0 = var2_2;
            throw v8;
        }
        catch (Pause v9) {
            var1_1 = UnwindState$L0O4.getOrCreate(var1_1);
            v9.pushState((UnwindState)var1_1);
            var1_1.state = 1;
            var1_1.o0 = var2_2;
            var1_1.o1 = var3_3;
            throw v9;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void localStmt(Object var1_1) throws CompileException, LuaError, Pause {
        block22: {
            block18: {
                block21: {
                    block20: {
                        block19: {
                            block17: {
                                if (var1_1 == null) {
                                    nvars = 0;
                                    e = new ExpDesc();
                                    while (true) {
                                        v0 = this;
                                        v1 = this;
                                        v2 = null;
lbl8:
                                        // 2 sources

                                        while (true) {
                                            v0.newLocal(v1.strCheckName(v2));
                                            ++nvars;
                                            v3 = this;
                                            v4 = 44;
                                            v5 = null;
                                            break block17;
                                            break;
                                        }
                                        break;
                                    }
                                }
                                var1_1 = (UnwindState$L4O4)var1_1;
                                switch (var1_1.state) {
                                    default: {
                                        throw new IllegalStateException("Resuming into unknown state");
                                    }
                                    case 0: {
                                        var2_2 = (int)var1_1.l0;
                                        var3_3 = (ExpDesc)var1_1.o0;
                                        v0 = this;
                                        v1 = this;
                                        v2 = var1_1.child;
                                        ** continue;
                                    }
                                    case 1: {
                                        var2_2 = (int)var1_1.l0;
                                        var3_3 = (ExpDesc)var1_1.o0;
                                        v3 = this;
                                        v4 = 0;
                                        v5 = var1_1.child;
                                        break;
                                    }
                                    case 2: {
                                        var2_2 = (int)var1_1.l0;
                                        var3_3 = (ExpDesc)var1_1.o0;
                                        v6 = this;
                                        v7 = 0;
                                        v8 = var1_1.child;
                                        break block19;
                                    }
                                    case 3: {
                                        var2_2 = (int)var1_1.l0;
                                        var3_3 = (ExpDesc)var1_1.o0;
                                        v9 = this;
                                        v10 = null;
                                        v11 = var1_1.child;
                                        break block20;
                                    }
                                }
                            }
                            try {
                                if (v3.testNext(v4, v5)) ** continue;
                                v6 = this;
                                v7 = 61;
                                v8 = null;
                            }
                            catch (Pause v12) {
                                var1_1 = UnwindState$L4O4.getOrCreate(var1_1);
                                v12.pushState((UnwindState)var1_1);
                                var1_1.state = 1;
                                var1_1.l0 = var2_2;
                                var1_1.o0 = var3_3;
                                throw v12;
                            }
                        }
                        try {
                            if (!v6.testNext(v7, v8)) break block18;
                            v9 = this;
                            v10 = e;
                            v11 = null;
                        }
                        catch (Pause v13) {
                            var1_1 = UnwindState$L4O4.getOrCreate(var1_1);
                            v13.pushState((UnwindState)var1_1);
                            var1_1.state = 2;
                            var1_1.l0 = var2_2;
                            var1_1.o0 = var3_3;
                            throw v13;
                        }
                    }
                    try {}
                    catch (Pause v14) {
                        var1_1 = UnwindState$L4O4.getOrCreate(var1_1);
                        v14.pushState((UnwindState)var1_1);
                        var1_1.state = 3;
                        var1_1.l0 = var2_2;
                        var1_1.o0 = var3_3;
                        throw v14;
                    }
                    break block21;
                    catch (Pause v15) {
                        var1_1 = UnwindState$L4O4.getOrCreate(var1_1);
                        v15.pushState((UnwindState)var1_1);
                        var1_1.state = 0;
                        var1_1.l0 = var2_2;
                        var1_1.o0 = var3_3;
                        throw v15;
                    }
                }
                nexps = v9.expList1(v10, v11);
                break block22;
            }
            e.kind = ExpKind.VVOID;
            nexps = 0;
        }
        this.adjustAssign(nvars, nexps, e);
        this.adjustLocalVars(nvars);
    }

    /*
     * Unable to fully structure code
     */
    private boolean funcName(ExpDesc var1_1, Object var2_2) throws CompileException, LuaError, Pause {
        block15: {
            if (var2_2 != null) break block15;
            v0 = this;
            v1 = v;
            v2 = null;
lbl5:
            // 2 sources

            while (true) {
                v0.singleVar(v1, v2);
                block12: while (this.lexer.token.token() == 46) {
                    v3 = this;
                    v4 = v;
                    v5 = null;
lbl12:
                    // 2 sources

                    while (true) {
                        v3.fieldSelect(v4, v5);
                        continue block12;
                        break;
                    }
                }
                needSelf = false;
                if (this.lexer.token.token() != 58) ** GOTO lbl25
                needSelf = true;
                v6 = this;
                v7 = v;
                v8 = null;
lbl22:
                // 2 sources

                while (true) {
                    v6.fieldSelect(v7, v8);
lbl25:
                    // 2 sources

                    return needSelf;
                }
                break;
            }
        }
        var2_2 = (UnwindState$L4O4)var2_2;
        switch (var2_2.state) {
            default: {
                throw new IllegalStateException("Resuming into unknown state");
            }
            case 0: {
                var1_1 = (ExpDesc)var2_2.o0;
                v0 = this;
                v1 = null;
                v2 = var2_2.child;
                ** continue;
            }
            case 1: {
                var1_1 = (ExpDesc)var2_2.o0;
                v3 = this;
                v4 = null;
                v5 = var2_2.child;
                ** continue;
            }
            case 2: 
        }
        var3_3 = (int)var2_2.l0;
        v6 = this;
        v7 = null;
        v8 = var2_2.child;
        ** while (true)
        catch (Pause v9) {
            var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
            v9.pushState((UnwindState)var2_2);
            var2_2.state = 0;
            var2_2.o0 = var1_1;
            throw v9;
        }
        catch (Pause v10) {
            var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
            v10.pushState((UnwindState)var2_2);
            var2_2.state = 1;
            var2_2.o0 = var1_1;
            throw v10;
        }
        catch (Pause v11) {
            var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
            v11.pushState((UnwindState)var2_2);
            var2_2.state = 2;
            var2_2.l0 = var3_3;
            throw v11;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void funcStmt(Object var1_1) throws CompileException, LuaError, Pause {
        if (var1_1 == null) {
            position = this.lexer.token.position();
            v0 = this.lexer;
            v1 = null;
lbl5:
            // 2 sources

            while (true) {
                v0.nextToken(v1);
                v = new ExpDesc();
                b = new ExpDesc();
                v2 = this;
                v3 = v;
                v4 = null;
lbl13:
                // 2 sources

                while (true) {
                    needSelf = v2.funcName(v3, v4);
                    v5 = this;
                    v6 = b;
                    v7 = needSelf;
                    v8 = Lex.unpackLine(position);
                    v9 = null;
lbl21:
                    // 2 sources

                    while (true) {
                        v5.body(v6, v7, v8, v9);
                        this.fs.storeVar(v, b);
                        this.fs.fixPosition(position);
                        return;
                        break;
                    }
                    break;
                }
                break;
            }
        }
        var1_1 = (UnwindState$L4O4)var1_1;
        switch (var1_1.state) {
            default: {
                throw new IllegalStateException("Resuming into unknown state");
            }
            case 0: {
                var2_2 = var1_1.l0;
                v0 = this.lexer;
                v1 = var1_1.child;
                ** continue;
            }
            case 1: {
                var2_2 = var1_1.l0;
                var4_3 = (ExpDesc)var1_1.o0;
                var5_4 = (ExpDesc)var1_1.o1;
                v2 = this;
                v3 = null;
                v4 = var1_1.child;
                ** continue;
            }
            case 2: 
        }
        var2_2 = var1_1.l0;
        var4_3 = (ExpDesc)var1_1.o0;
        var5_4 = (ExpDesc)var1_1.o1;
        v5 = this;
        v6 = null;
        v7 = false;
        v8 = 0;
        v9 = var1_1.child;
        ** while (true)
        catch (Pause v10) {
            var1_1 = UnwindState$L4O4.getOrCreate(var1_1);
            v10.pushState((UnwindState)var1_1);
            var1_1.state = 0;
            var1_1.l0 = var2_2;
            throw v10;
        }
        catch (Pause v11) {
            var1_1 = UnwindState$L4O4.getOrCreate(var1_1);
            v11.pushState((UnwindState)var1_1);
            var1_1.state = 1;
            var1_1.l0 = var2_2;
            var1_1.o0 = var4_3;
            var1_1.o1 = var5_4;
            throw v11;
        }
        catch (Pause v12) {
            var1_1 = UnwindState$L4O4.getOrCreate(var1_1);
            v12.pushState((UnwindState)var1_1);
            var1_1.state = 2;
            var1_1.l0 = var2_2;
            var1_1.o0 = var4_3;
            var1_1.o1 = var5_4;
            throw v12;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void exprStmt(Object var1_1) throws CompileException, LuaError, Pause {
        if (var1_1 == null) {
            fs = this.fs;
            v = new LhsAssign(null);
            v0 = this;
            v1 = v.v;
            v2 = null;
lbl7:
            // 2 sources

            while (true) {
                block14: {
                    block13: {
                        v0.suffixedExpression(v1, v2);
                        if (this.lexer.token.token() != 61 && this.lexer.token.token() != 44) break block13;
                        v3 = this;
                        v4 = v;
                        v5 = 1;
                        v6 = null;
lbl15:
                        // 2 sources

                        while (true) {
                            v3.assignment(v4, v5, v6);
                            break block14;
                            break;
                        }
                    }
                    if (v.v.kind == ExpKind.VCALL) {
                        fs.code[v.v.info] = LuaC.SETARG_C(fs.code[v.v.info], 1);
                    } else {
                        throw this.syntaxError("syntax error");
                    }
                }
                return;
            }
        }
        var1_1 = (UnwindState$L0O4)var1_1;
        switch (var1_1.state) {
            default: {
                throw new IllegalStateException("Resuming into unknown state");
            }
            case 0: {
                var2_2 = (FuncState)var1_1.o0;
                var3_3 = (LhsAssign)var1_1.o1;
                v0 = this;
                v1 = null;
                v2 = var1_1.child;
                ** continue;
            }
            case 1: 
        }
        v3 = this;
        v4 = null;
        v5 = 0;
        v6 = var1_1.child;
        ** while (true)
        catch (Pause v7) {
            var1_1 = UnwindState$L0O4.getOrCreate(var1_1);
            v7.pushState((UnwindState)var1_1);
            var1_1.state = 0;
            var1_1.o0 = var2_2;
            var1_1.o1 = var3_3;
            throw v7;
        }
        catch (Pause v8) {
            var1_1 = UnwindState$L0O4.getOrCreate(var1_1);
            v8.pushState((UnwindState)var1_1);
            var1_1.state = 1;
            throw v8;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void returnStmt(Object var1_1) throws CompileException, LuaError, Pause {
        block20: {
            if (var1_1 != null) break block20;
            fs = this.fs;
            v0 = this.lexer;
            v1 = null;
lbl5:
            // 2 sources

            while (true) {
                block21: {
                    v0.nextToken(v1);
                    if (!this.blockFollow(true) && this.lexer.token.token() != 59) break block21;
                    nret = 0;
                    first = 0;
                    ** GOTO lbl38
                }
                e = new ExpDesc();
                v2 = this;
                v3 = e;
                v4 = null;
lbl17:
                // 2 sources

                while (true) {
                    block22: {
                        block18: {
                            block19: {
                                nret = v2.expList1(v3, v4);
                                if (!e.kind.hasMultiRet()) break block18;
                                fs.setMultiRet(e);
                                if (e.kind != ExpKind.VCALL || nret != 1) break block19;
                                op = fs.code[e.info] = LuaC.SET_OPCODE(fs.code[e.info], 30);
                                if (!Parser.$assertionsDisabled && Lua.GETARG_A(op) != fs.activeVariableCount) {
                                    throw new AssertionError();
                                }
                            }
                            first = fs.activeVariableCount;
                            nret = -1;
                            break block22;
                        }
                        if (nret == 1) {
                            first = fs.exp2AnyReg(e);
                        } else {
                            fs.exp2NextReg(e);
                            first = fs.activeVariableCount;
                            if (!Parser.$assertionsDisabled && nret != fs.freeReg - first) {
                                throw new AssertionError();
                            }
                        }
                    }
                    fs.ret(first, nret);
                    v5 = this;
                    v6 = 59;
                    v7 = null;
lbl43:
                    // 2 sources

                    while (true) {
                        v5.testNext(v6, v7);
                        return;
                    }
                    break;
                }
                break;
            }
        }
        var1_1 = (UnwindState$L0O4)var1_1;
        switch (var1_1.state) {
            default: {
                throw new IllegalStateException("Resuming into unknown state");
            }
            case 0: {
                var2_2 = (FuncState)var1_1.o0;
                v0 = this.lexer;
                v1 = var1_1.child;
                ** continue;
            }
            case 1: {
                var2_2 = (FuncState)var1_1.o0;
                var5_5 = (ExpDesc)var1_1.o1;
                v2 = this;
                v3 = null;
                v4 = var1_1.child;
                ** continue;
            }
            case 2: 
        }
        v5 = this;
        v6 = 0;
        v7 = var1_1.child;
        ** while (true)
        catch (Pause v8) {
            var1_1 = UnwindState$L0O4.getOrCreate(var1_1);
            v8.pushState((UnwindState)var1_1);
            var1_1.state = 0;
            var1_1.o0 = var2_2;
            throw v8;
        }
        catch (Pause v9) {
            var1_1 = UnwindState$L0O4.getOrCreate(var1_1);
            v9.pushState((UnwindState)var1_1);
            var1_1.state = 1;
            var1_1.o0 = var2_2;
            var1_1.o1 = var5_5;
            throw v9;
        }
        catch (Pause v10) {
            var1_1 = UnwindState$L0O4.getOrCreate(var1_1);
            v10.pushState((UnwindState)var1_1);
            var1_1.state = 2;
            throw v10;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean tryGoto(Object object) throws CompileException, LuaError, Pause {
        Object object2;
        Lex lex;
        if (object == null) {
            assert (this.lexer.token.token() == 288);
            if (this.lexer.token.stringContents() != this.gotoName) {
                return false;
            }
            lex = this.lexer;
            object2 = null;
        } else {
            object = (UnwindState)object;
            if (((UnwindState)object).state != 0) {
                throw new IllegalStateException("Resuming into unknown state");
            }
            lex = this.lexer;
            object2 = ((UnwindState)object).child;
        }
        try {
            if (lex.lookahead(object2).token() != 288) return false;
            return true;
        }
        catch (Pause pause) {
            object = UnwindState.getOrCreate(object);
            pause.pushState((UnwindState)object);
            ((UnwindState)object).state = 0;
            throw pause;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void statement(Object var1_1) throws CompileException, LuaError, Pause {
        block105: {
            if (var1_1 != null) break block105;
            this.enterLevel();
            switch (this.lexer.token.token()) {
                case 59: {
                    v0 = this.lexer;
                    v1 = null;
lbl7:
                    // 2 sources

                    while (true) {
                        v0.nextToken(v1);
                        ** break;
                        break;
                    }
                }
                case 267: {
                    v2 = this;
                    v3 = null;
                    ** GOTO lbl72
                }
                case 278: {
                    v4 = this;
                    v5 = null;
                    ** GOTO lbl76
                }
                case 259: {
                    line = this.lexer.token.line();
                    v6 = this.lexer;
                    v7 = null;
                    ** GOTO lbl80
                }
                case 264: {
                    v8 = this;
                    v9 = null;
                    ** GOTO lbl97
                }
                case 273: {
                    v10 = this;
                    v11 = null;
                    ** GOTO lbl101
                }
                case 265: {
                    v12 = this;
                    v13 = null;
                    ** GOTO lbl105
                }
                case 269: {
                    v14 = this.lexer;
                    v15 = null;
                    ** GOTO lbl109
                }
                case 285: {
                    line = this.lexer.token.line();
                    v16 = this.lexer;
                    v17 = null;
                    ** GOTO lbl130
                }
                case 274: {
                    v18 = this;
                    v19 = null;
                    ** GOTO lbl145
                }
                case 258: {
                    v20 = this;
                    v21 = this.fs.jump();
                    v22 = null;
                    ** GOTO lbl149
                }
                case 288: {
                    v23 = this;
                    v24 = null;
                    ** GOTO lbl153
                }
                default: {
                    v25 = this;
                    v26 = null;
                    break;
                }
            }
            ** GOTO lbl169
        }
        var1_1 = (UnwindState$L4O0)var1_1;
        switch (var1_1.state) {
            default: {
                throw new IllegalStateException("Resuming into unknown state");
            }
            case 0: {
                v0 = this.lexer;
                v1 = var1_1.child;
                ** continue;
            }
lbl72:
            // 2 sources

            while (true) {
                v2.ifStat(v3);
                ** break;
                break;
            }
lbl76:
            // 2 sources

            while (true) {
                v4.whileStmt(v5);
                ** break;
                break;
            }
lbl80:
            // 2 sources

            while (true) {
                v6.nextToken(v7);
                v27 = this;
                v28 = null;
lbl85:
                // 2 sources

                while (true) {
                    v27.block(v28);
                    v29 = this;
                    v30 = 262;
                    v31 = 259;
                    v32 = line;
                    v33 = null;
lbl93:
                    // 2 sources

                    while (true) {
                        v29.checkMatch(v30, v31, v32, v33);
                        ** break;
                        break;
                    }
                    break;
                }
                break;
            }
lbl97:
            // 2 sources

            while (true) {
                v8.forStmt(v9);
                ** break;
                break;
            }
lbl101:
            // 2 sources

            while (true) {
                v10.repeatStmt(v11);
                ** break;
                break;
            }
lbl105:
            // 2 sources

            while (true) {
                v12.funcStmt(v13);
                ** break;
                break;
            }
lbl109:
            // 2 sources

            while (true) {
                v14.nextToken(v15);
                v34 = this;
                v35 = 265;
                v36 = null;
lbl115:
                // 2 sources

                while (true) {
                    if (!v34.testNext(v35, v36)) ** GOTO lbl124
                    v37 = this;
                    v38 = null;
lbl120:
                    // 2 sources

                    while (true) {
                        v37.localFunc(v38);
                        ** break;
                        break;
                    }
lbl124:
                    // 1 sources

                    v39 = this;
                    v40 = null;
lbl126:
                    // 2 sources

                    while (true) {
                        v39.localStmt(v40);
                        ** break;
                        break;
                    }
                    break;
                }
                break;
            }
lbl130:
            // 2 sources

            while (true) {
                v16.nextToken(v17);
                v41 = this;
                v42 = this;
                v43 = null;
lbl136:
                // 2 sources

                while (true) {
                    v44 = v42.strCheckName(v43);
                    v45 = line;
                    v46 = null;
lbl141:
                    // 2 sources

                    while (true) {
                        v41.labelStat(v44, v45, v46);
                        ** break;
                        break;
                    }
                    break;
                }
                break;
            }
lbl145:
            // 2 sources

            while (true) {
                v18.returnStmt(v19);
                ** break;
                break;
            }
lbl149:
            // 2 sources

            while (true) {
                v20.breakStmt(v21, v22);
                ** break;
                break;
            }
lbl153:
            // 2 sources

            while (true) {
                if (!v23.tryGoto(v24)) ** GOTO lbl163
                v47 = this;
                v48 = this.fs.jump();
                v49 = null;
lbl159:
                // 2 sources

                while (true) {
                    v47.gotoStat(v48, v49);
                    ** break;
                    break;
                }
lbl163:
                // 1 sources

                v50 = this;
                v51 = null;
lbl165:
                // 2 sources

                while (true) {
                    v50.exprStmt(v51);
                    ** break;
                    break;
                }
                break;
            }
lbl169:
            // 2 sources

            while (true) {
                try {}
                catch (Pause v52) {
                    var1_1 = UnwindState$L4O0.getOrCreate(var1_1);
                    v52.pushState((UnwindState)var1_1);
                    var1_1.state = 21;
                    throw v52;
                }
                ** GOTO lbl286
                break;
            }
            catch (Pause v53) {
                var1_1 = UnwindState$L4O0.getOrCreate(var1_1);
                v53.pushState((UnwindState)var1_1);
                var1_1.state = 20;
                throw v53;
            }
            catch (Pause v54) {
                var1_1 = UnwindState$L4O0.getOrCreate(var1_1);
                v54.pushState((UnwindState)var1_1);
                var1_1.state = 19;
                throw v54;
            }
            catch (Pause v55) {
                var1_1 = UnwindState$L4O0.getOrCreate(var1_1);
                v55.pushState((UnwindState)var1_1);
                var1_1.state = 18;
                throw v55;
            }
            catch (Pause v56) {
                var1_1 = UnwindState$L4O0.getOrCreate(var1_1);
                v56.pushState((UnwindState)var1_1);
                var1_1.state = 17;
                throw v56;
            }
            catch (Pause v57) {
                var1_1 = UnwindState$L4O0.getOrCreate(var1_1);
                v57.pushState((UnwindState)var1_1);
                var1_1.state = 16;
                throw v57;
            }
            catch (Pause v58) {
                var1_1 = UnwindState$L4O0.getOrCreate(var1_1);
                v58.pushState((UnwindState)var1_1);
                var1_1.state = 15;
                throw v58;
            }
            catch (Pause v59) {
                var1_1 = UnwindState$L4O0.getOrCreate(var1_1);
                v59.pushState((UnwindState)var1_1);
                var1_1.state = 14;
                var1_1.l0 = var2_3;
                throw v59;
            }
            catch (Pause v60) {
                var1_1 = UnwindState$L4O0.getOrCreate(var1_1);
                v60.pushState((UnwindState)var1_1);
                var1_1.state = 13;
                var1_1.l0 = var2_3;
                throw v60;
            }
            catch (Pause v61) {
                var1_1 = UnwindState$L4O0.getOrCreate(var1_1);
                v61.pushState((UnwindState)var1_1);
                var1_1.state = 12;
                throw v61;
            }
            catch (Pause v62) {
                var1_1 = UnwindState$L4O0.getOrCreate(var1_1);
                v62.pushState((UnwindState)var1_1);
                var1_1.state = 11;
                throw v62;
            }
            catch (Pause v63) {
                var1_1 = UnwindState$L4O0.getOrCreate(var1_1);
                v63.pushState((UnwindState)var1_1);
                var1_1.state = 10;
                throw v63;
            }
            catch (Pause v64) {
                var1_1 = UnwindState$L4O0.getOrCreate(var1_1);
                v64.pushState((UnwindState)var1_1);
                var1_1.state = 9;
                throw v64;
            }
            catch (Pause v65) {
                var1_1 = UnwindState$L4O0.getOrCreate(var1_1);
                v65.pushState((UnwindState)var1_1);
                var1_1.state = 8;
                throw v65;
            }
            catch (Pause v66) {
                var1_1 = UnwindState$L4O0.getOrCreate(var1_1);
                v66.pushState((UnwindState)var1_1);
                var1_1.state = 7;
                throw v66;
            }
            catch (Pause v67) {
                var1_1 = UnwindState$L4O0.getOrCreate(var1_1);
                v67.pushState((UnwindState)var1_1);
                var1_1.state = 6;
                throw v67;
            }
            catch (Pause v68) {
                var1_1 = UnwindState$L4O0.getOrCreate(var1_1);
                v68.pushState((UnwindState)var1_1);
                var1_1.state = 5;
                throw v68;
            }
            catch (Pause v69) {
                var1_1 = UnwindState$L4O0.getOrCreate(var1_1);
                v69.pushState((UnwindState)var1_1);
                var1_1.state = 4;
                var1_1.l0 = var2_2;
                throw v69;
            }
            catch (Pause v70) {
                var1_1 = UnwindState$L4O0.getOrCreate(var1_1);
                v70.pushState((UnwindState)var1_1);
                var1_1.state = 3;
                var1_1.l0 = var2_2;
                throw v70;
            }
            catch (Pause v71) {
                var1_1 = UnwindState$L4O0.getOrCreate(var1_1);
                v71.pushState((UnwindState)var1_1);
                var1_1.state = 2;
                throw v71;
            }
            catch (Pause v72) {
                var1_1 = UnwindState$L4O0.getOrCreate(var1_1);
                v72.pushState((UnwindState)var1_1);
                var1_1.state = 1;
                throw v72;
            }
            catch (Pause v73) {
                var1_1 = UnwindState$L4O0.getOrCreate(var1_1);
                v73.pushState((UnwindState)var1_1);
                var1_1.state = 0;
                throw v73;
            }
lbl286:
            // 1 sources

            v25.exprStmt(v26);
lbl287:
            // 15 sources

            if (!(Parser.$assertionsDisabled || this.fs.maxStackSize >= this.fs.freeReg && this.fs.freeReg >= this.fs.activeVariableCount)) {
                throw new AssertionError();
            }
            this.fs.freeReg = this.fs.activeVariableCount;
            this.leaveLevel();
            return;
            case 1: {
                v2 = this;
                v3 = var1_1.child;
                ** continue;
            }
            case 2: {
                v4 = this;
                v5 = var1_1.child;
                ** continue;
            }
            case 3: {
                var2_2 = (int)var1_1.l0;
                v6 = this.lexer;
                v7 = var1_1.child;
                ** continue;
            }
            case 4: {
                var2_2 = (int)var1_1.l0;
                v27 = this;
                v28 = var1_1.child;
                ** continue;
            }
            case 5: {
                v29 = this;
                v30 = 0;
                v31 = 0;
                v32 = 0;
                v33 = var1_1.child;
                ** continue;
            }
            case 6: {
                v8 = this;
                v9 = var1_1.child;
                ** continue;
            }
            case 7: {
                v10 = this;
                v11 = var1_1.child;
                ** continue;
            }
            case 8: {
                v12 = this;
                v13 = var1_1.child;
                ** continue;
            }
            case 9: {
                v14 = this.lexer;
                v15 = var1_1.child;
                ** continue;
            }
            case 10: {
                v34 = this;
                v35 = 0;
                v36 = var1_1.child;
                ** continue;
            }
            case 11: {
                v37 = this;
                v38 = var1_1.child;
                ** continue;
            }
            case 12: {
                v39 = this;
                v40 = var1_1.child;
                ** continue;
            }
            case 13: {
                var2_3 = (int)var1_1.l0;
                v16 = this.lexer;
                v17 = var1_1.child;
                ** continue;
            }
            case 14: {
                var2_3 = (int)var1_1.l0;
                v41 = this;
                v42 = this;
                v43 = var1_1.child;
                ** continue;
            }
            case 15: {
                v41 = this;
                v44 = null;
                v45 = 0;
                v46 = var1_1.child;
                ** continue;
            }
            case 16: {
                v18 = this;
                v19 = var1_1.child;
                ** continue;
            }
            case 17: {
                v20 = this;
                v21 = 0;
                v22 = var1_1.child;
                ** continue;
            }
            case 18: {
                v23 = this;
                v24 = var1_1.child;
                ** continue;
            }
            case 19: {
                v47 = this;
                v48 = 0;
                v49 = var1_1.child;
                ** continue;
            }
            case 20: {
                v50 = this;
                v51 = var1_1.child;
                ** continue;
            }
            case 21: 
        }
        v25 = this;
        v26 = var1_1.child;
        ** while (true)
    }

    /*
     * Unable to fully structure code
     */
    public Prototype mainFunction(Object var1_1) throws CompileException, LuaError, Pause {
        if (var1_1 == null) {
            funcstate = this.openFunc();
            funcstate.isVararg = true;
            v = new ExpDesc();
            v.init(ExpKind.VLOCAL, 0);
            this.newUpvalue(funcstate, this.envName, v);
            v0 = this.lexer;
            v1 = null;
lbl10:
            // 2 sources

            while (true) {
                v0.nextToken(v1);
                v2 = this;
                v3 = null;
lbl15:
                // 2 sources

                while (true) {
                    v2.statementList(v3);
                    this.check(286);
                    prototype = this.closeFunc();
                    if (!Parser.$assertionsDisabled && funcstate.upvalues.size() != 1) {
                        throw new AssertionError();
                    }
                    if (!Parser.$assertionsDisabled && this.fs != null) {
                        throw new AssertionError();
                    }
                    return prototype;
                    break;
                }
                break;
            }
        }
        var1_1 = (UnwindState$L0O4)var1_1;
        switch (var1_1.state) {
            default: {
                throw new IllegalStateException("Resuming into unknown state");
            }
            case 0: {
                var2_2 = (FuncState)var1_1.o0;
                v0 = this.lexer;
                v1 = var1_1.child;
                ** continue;
            }
            case 1: 
        }
        var2_2 = (FuncState)var1_1.o0;
        v2 = this;
        v3 = var1_1.child;
        ** while (true)
        catch (Pause v4) {
            var1_1 = UnwindState$L0O4.getOrCreate(var1_1);
            v4.pushState((UnwindState)var1_1);
            var1_1.state = 0;
            var1_1.o0 = var2_2;
            throw v4;
        }
        catch (Pause v5) {
            var1_1 = UnwindState$L0O4.getOrCreate(var1_1);
            v5.pushState((UnwindState)var1_1);
            var1_1.state = 1;
            var1_1.o0 = var2_2;
            throw v5;
        }
    }

    static class ExpDesc {
        ExpKind kind;
        long position;
        private LuaNumber nval;
        int info;
        int aux;
        @Nullable ExpKind tableType;
        final IntPtr t = new IntPtr();
        final IntPtr f = new IntPtr();

        ExpDesc() {
        }

        void init(ExpKind kind, int info) {
            this.kind = kind;
            this.info = info;
            this.f.value = -1;
            this.t.value = -1;
        }

        public void setNval(LuaNumber r) {
            this.nval = r;
        }

        public LuaNumber nval() {
            return this.nval == null ? LuaInteger.valueOf(this.info) : this.nval;
        }

        boolean hasjumps() {
            return this.t.value != this.f.value;
        }

        boolean isnumeral() {
            return this.kind == ExpKind.VKNUM && this.t.value == -1 && this.f.value == -1;
        }

        public void setValue(ExpDesc other) {
            this.kind = other.kind;
            this.nval = other.nval;
            this.info = other.info;
            this.aux = other.aux;
            this.t.value = other.t.value;
            this.f.value = other.f.value;
        }

        public void setConstant(int constantIndex) {
            this.kind = ExpKind.VK;
            this.info = constantIndex;
        }
    }

    static final class LabelDesc {
        private final LuaString name;
        private final int pc;
        private final int line;
        private short activeVariables;

        LabelDesc(LuaString name, int pc, int line, short activeVariables) {
            this.name = name;
            this.pc = pc;
            this.line = line;
            this.activeVariables = activeVariables;
        }
    }

    static class ConsControl {
        final ExpDesc v = new ExpDesc();
        final ExpDesc table;
        int hashSize;
        int arraySize;
        int toStore;

        ConsControl(ExpDesc table) {
            this.table = table;
        }
    }

    static class LhsAssign {
        final LhsAssign prev;
        final ExpDesc v = new ExpDesc();

        LhsAssign(LhsAssign prev) {
            this.prev = prev;
        }
    }
}

